package ai.digital.deploy.cache.config

import ai.digital.configuration.central.deploy.{ClusterProperties, TaskerSystemProperties}
import com.xebialabs.xlplatform.cluster.ClusterMode.STANDALONE
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import javax.annotation.PostConstruct

@Component
class CacheMode(@Autowired taskerSystemProperties: TaskerSystemProperties,
                @Autowired clusterProperties: ClusterProperties) extends Logging {

  @PostConstruct
  def setCacheMode(): Unit = {
    CacheMode.embeddedCacheMode = taskerSystemProperties.inProcessWorker &&
      clusterProperties.mode.equals(STANDALONE)
    logger.info(s"cache mode set to ${CacheMode.getCacheMode}")
  }

}

object CacheMode {
  val EMBEDDED = "embedded"
  val STANDALONE = "standalone"
  var embeddedCacheMode: Boolean = false

  def getCacheMode: String = {
    if (CacheMode.embeddedCacheMode) {
      EMBEDDED
    } else {
      STANDALONE
    }
  }
}
