/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.cache.actuator;

import ai.digital.configuration.central.deploy.CachesProperties;
import ai.digital.deploy.cache.actuator.CachesInfo;
import ai.digital.deploy.cache.actuator.Configured;
import ai.digital.deploy.cache.actuator.Evaluated;
import ai.digital.deploy.cache.config.CacheMode$;
import ai.digital.deploy.cache.config.CacheProvider;
import ai.digital.deploy.cache.service.AppCacheDataService;
import ai.digital.deploy.cache.service.CacheDataService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@DependsOn(value={"cacheMode"})
@Endpoint(id="jcaches")
@ScalaSignature(bytes="\u0006\u0005\t\rc\u0001\u0002\b\u0010\u0001iA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"AA\n\u0001B\u0001B\u0003%Q\nC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003z\u0001\u0011\u0005!\u0010C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004bBA:\u0001\u0011%\u0011Q\u000f\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\tI\n\u0001C\u0005\u00037Cq!!/\u0001\t\u0013\tY\fC\u0004\u0002`\u0002!I!!9\u0003\u001f)\u001b\u0015m\u00195fg\u0016sG\r]8j]RT!\u0001E\t\u0002\u0011\u0005\u001cG/^1u_JT!AE\n\u0002\u000b\r\f7\r[3\u000b\u0005Q)\u0012A\u00023fa2|\u0017P\u0003\u0002\u0017/\u00059A-[4ji\u0006d'\"\u0001\r\u0002\u0005\u0005L7\u0001A\n\u0004\u0001m\t\u0003C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g\r\u0005\u0002#O5\t1E\u0003\u0002%K\u0005)1\u000f\u001c45U*\ta%\u0001\u0005he&T(\u0010\\3e\u0013\tA3EA\u0004M_\u001e<\u0017N\\4\u0002!\r\f7\r[3t!J|\u0007/\u001a:uS\u0016\u001c\bCA\u00162\u001b\u0005a#B\u0001\u000b.\u0015\tqs&A\u0004dK:$(/\u00197\u000b\u0005A*\u0012!D2p]\u001aLw-\u001e:bi&|g.\u0003\u00023Y\t\u00012)Y2iKN\u0004&o\u001c9feRLWm\u001d\u0015\u0003\u0003Q\u0002\"!\u000e!\u000e\u0003YR!a\u000e\u001d\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002:u\u00059a-Y2u_JL(BA\u001e=\u0003\u0015\u0011W-\u00198t\u0015\tid(A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005y\u0014aA8sO&\u0011\u0011I\u000e\u0002\n\u0003V$xn^5sK\u0012\fQbY1dQ\u0016\u0004&o\u001c<jI\u0016\u0014\bC\u0001#H\u001b\u0005)%B\u0001$\u0012\u0003\u0019\u0019wN\u001c4jO&\u0011\u0001*\u0012\u0002\u000e\u0007\u0006\u001c\u0007.\u001a)s_ZLG-\u001a:)\t\t!$jS\u0001\te\u0016\fX/\u001b:fIf\t\u0001!A\tdC\u000eDW\rR1uCN+'O^5dKN\u00042AT*V\u001b\u0005y%B\u0001)R\u0003\u0011)H/\u001b7\u000b\u0003I\u000bAA[1wC&\u0011Ak\u0014\u0002\u0005\u0019&\u001cH\u000fM\u0002W=\u0016\u0004Ba\u0016.]I6\t\u0001L\u0003\u0002Z#\u000591/\u001a:wS\u000e,\u0017BA.Y\u0005M\t\u0005\u000f]\"bG\",G)\u0019;b'\u0016\u0014h/[2f!\tif\f\u0004\u0001\u0005\u0013}\u001b\u0011\u0011!A\u0001\u0006\u0003\u0001'aA0%cE\u0011\u0011m\u0007\t\u00039\tL!aY\u000f\u0003\u000f9{G\u000f[5oOB\u0011Q,\u001a\u0003\nM\u000e\t\t\u0011!A\u0003\u0002\u0001\u00141a\u0018\u00133Q\t\u0019A'\u0001\u0004=S:LGO\u0010\u000b\u0005U2t\u0007\u000f\u0005\u0002l\u00015\tq\u0002C\u0003*\t\u0001\u0007!\u0006\u000b\u0002mi!)!\t\u0002a\u0001\u0007\"\"a\u000e\u000e&L\u0011\u0015aE\u00011\u0001r!\rq5K\u001d\u0019\u0004gV<\b\u0003B,[iZ\u0004\"!X;\u0005\u0013}\u0003\u0018\u0011!A\u0001\u0006\u0003\u0001\u0007CA/x\t%1\u0007/!A\u0001\u0002\u000b\u0005\u0001\r\u000b\u0002qi\u0005!\u0011N\u001c4p)\u0005Y\bCA6}\u0013\tixB\u0001\u0006DC\u000eDWm]%oM>D#!B@\u0011\t\u0005\u0005\u0011\u0011C\u0007\u0003\u0003\u0007Q1aNA\u0003\u0015\u0011\t9!!\u0003\u0002\u0011\u0015tG\r]8j]RTA!a\u0003\u0002\u000e\u00059\u0011m\u0019;vCR,'bAA\by\u0005!!m\\8u\u0013\u0011\t\u0019\"a\u0001\u0003\u001bI+\u0017\rZ(qKJ\fG/[8o\u0003)\u0019\u0017m\u00195f\u000b:$(/\u001f\u000b\u0007\u00033\ti#a\u00141\t\u0005m\u0011\u0011\u0006\t\u0007\u0003;\t\u0019#a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003\u000b\t1a^3c\u0013\u0011\t)#a\b\u0003']+'-\u00128ea>Lg\u000e\u001e*fgB|gn]3\u0011\u0007u\u000bI\u0003\u0002\u0006\u0002,\u0019\t\t\u0011!A\u0003\u0002\u0001\u00141a\u0018\u00134\u0011\u001d\tyC\u0002a\u0001\u0003c\t\u0011bY1dQ\u0016t\u0015-\\3\u0011\t\u0005M\u0012\u0011\t\b\u0005\u0003k\ti\u0004E\u0002\u00028ui!!!\u000f\u000b\u0007\u0005m\u0012$\u0001\u0004=e>|GOP\u0005\u0004\u0003\u007fi\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002D\u0005\u0015#AB*ue&twMC\u0002\u0002@uAC!!\f\u0002JA!\u0011\u0011AA&\u0013\u0011\ti%a\u0001\u0003\u0011M+G.Z2u_JDq!!\u0015\u0007\u0001\u0004\t\t$A\u0002lKfD#AB@\u0002\u0017\rdW-\u0019:DC\u000eDWm\u001d\u000b\u0003\u00033\u0002b!!\b\u0002$\u0005m\u0003c\u0001\u000f\u0002^%\u0019\u0011qL\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0004\u000f\u0005\r\u0004\u0003BA\u0001\u0003KJA!a\u001a\u0002\u0004\tyA)\u001a7fi\u0016|\u0005/\u001a:bi&|g.\u0001\u0006dY\u0016\f'oQ1dQ\u0016$B!!\u0017\u0002n!9\u0011q\u0006\u0005A\u0002\u0005E\u0002\u0006BA7\u0003\u0013B3\u0001CA2\u0003Y9\u0018\u000e\u001e5DC\u000eDW\r\u0015:pm&$WM]\"iK\u000e\\W\u0003BA<\u0003{\"B!!\u001f\u0002\nB1\u0011QDA\u0012\u0003w\u00022!XA?\t\u001d\ty(\u0003b\u0001\u0003\u0003\u0013\u0011aS\t\u0004C\u0006\r\u0005c\u0001\u000f\u0002\u0006&\u0019\u0011qQ\u000f\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\f&!\t\u0019AAG\u0003\u0015\u0011Gn\\2l!\u0015a\u0012qRA=\u0013\r\t\t*\b\u0002\ty\tLh.Y7f}\u0005Iq-\u001a;DC\u000eDWm]\u000b\u0003\u0003/\u0003BAT*\u00022\u0005\u0019r-\u001a;DC\u000eDW\rR1uCN+'O^5dKR!\u0011QTA\\!\u0015a\u0012qTAR\u0013\r\t\t+\b\u0002\u0007\u001fB$\u0018n\u001c81\r\u0005\u0015\u0016QVAZ!\u001d9\u0016qUAV\u0003cK1!!+Y\u0005A\u0019\u0015m\u00195f\t\u0006$\u0018mU3sm&\u001cW\rE\u0002^\u0003[#!\"a,\f\u0003\u0003\u0005\tQ!\u0001a\u0005\ryF\u0005\u000e\t\u0004;\u0006MFACA[\u0017\u0005\u0005\t\u0011!B\u0001A\n\u0019q\fJ\u001b\t\u000f\u0005=2\u00021\u0001\u00022\u0005Qr-\u001a;DC\u000eDW\rR1uCN+'O^5dK.+\u0017\u0010V=qKR!\u0011QXAfa\u0011\ty,a2\u0011\r\u0005M\u0012\u0011YAc\u0013\u0011\t\u0019-!\u0012\u0003\u000b\rc\u0017m]:\u0011\u0007u\u000b9\rB\u0006\u0002J2\t\t\u0011!A\u0003\u0002\u0005\u0005%aA0%q!9\u0011Q\u001a\u0007A\u0002\u0005=\u0017aA2egB2\u0011\u0011[Ak\u00037\u0004raVAT\u0003'\fI\u000eE\u0002^\u0003+$1\"a6\u0002L\u0006\u0005\t\u0011!B\u0001A\n\u0019q\f\n\u001c\u0011\u0007u\u000bY\u000eB\u0006\u0002^\u0006-\u0017\u0011!A\u0001\u0006\u0003\u0001'aA0%o\u0005iq-\u001a;DC\u000eDWMV1mk\u0016$\u0002\"a9\u0002n\u0006=\u0018Q \u0019\u0005\u0003K\fI\u000f\u0005\u0004\u0002\u001e\u0005\r\u0012q\u001d\t\u0004;\u0006%HACAv\u001b\u0005\u0005\t\u0011!B\u0001A\n!q\fJ\u00194\u0011\u001d\t\t&\u0004a\u0001\u0003cAq!!=\u000e\u0001\u0004\t\u00190\u0001\u0004uCJ<W\r\u001e\u0019\u0005\u0003k\fI\u0010\u0005\u0004\u00024\u0005\u0005\u0017q\u001f\t\u0004;\u0006eH\u0001DA~\u0003_\f\t\u0011!A\u0003\u0002\u0005\u0005%\u0001B0%cABq!!4\u000e\u0001\u0004\ty\u0010\r\u0004\u0003\u0002\t\u0015!1\u0002\t\b/\u0006\u001d&1\u0001B\u0005!\ri&Q\u0001\u0003\f\u0005\u000f\ti0!A\u0001\u0002\u000b\u0005\u0001M\u0001\u0003`IE\n\u0004cA/\u0003\f\u0011Y!QBA\u007f\u0003\u0003\u0005\tQ!\u0001a\u0005\u0011yF%\r\u001a)\u0007\u0001\u0011\t\u0002\u0005\u0003\u0003\u0014\teQB\u0001B\u000b\u0015\r\u00119\u0002P\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002B\u000e\u0005+\u0011\u0011bQ8na>tWM\u001c;)\u000f\u0001\u0011yB!\f\u00030A!!\u0011\u0005B\u0015\u001b\t\u0011\u0019CC\u00028\u0005KQ1Aa\n=\u0003\u001d\u0019wN\u001c;fqRLAAa\u000b\u0003$\tIA)\u001a9f]\u0012\u001cxJ\\\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0005c\t#Aa\r\u0002\u0013\r\f7\r[3N_\u0012,\u0007f\u0002\u0001\u00038\tu\"q\b\t\u0005\u0003\u0003\u0011I$\u0003\u0003\u0003<\u0005\r!\u0001C#oIB|\u0017N\u001c;\u0002\u0005%$\u0017E\u0001B!\u0003\u001dQ7-Y2iKN\u0004")
public class JCachesEndpoint
implements Logging {
    @Autowired
    private final CachesProperties cachesProperties;
    @Autowired(required=false)
    private final CacheProvider cacheProvider;
    @Autowired
    private final List<AppCacheDataService<?, ?>> cacheDataServices;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JCachesEndpoint jCachesEndpoint = this;
        synchronized (jCachesEndpoint) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @ReadOperation
    public CachesInfo info() {
        return new CachesInfo(new Configured(this.cachesProperties.appCaches().enabled()), new Evaluated(CacheMode$.MODULE$.getCacheMode(), this.cacheProvider != null ? this.cacheProvider.getType() : null, this.cacheProvider != null), this.getCaches());
    }

    @ReadOperation
    public WebEndpointResponse<?> cacheEntry(@Selector String cacheName, String key) {
        WebEndpointResponse notFoundResponse = new WebEndpointResponse(null, 404);
        return this.withCacheProviderCheck((Function0 & Serializable)() -> {
            Option<CacheDataService<?, ?>> option = this.getCacheDataService(cacheName);
            if (option instanceof Some) {
                Some some = (Some)option;
                CacheDataService cds = (CacheDataService)some.value();
                Class<?> keyType = this.getCacheDataServiceKeyType(cds);
                return this.getCacheValue(key, keyType, cds);
            }
            if (None$.MODULE$.equals(option)) {
                return notFoundResponse;
            }
            throw new MatchError(option);
        });
    }

    @DeleteOperation
    public WebEndpointResponse<BoxedUnit> clearCaches() {
        return this.withCacheProviderCheck((Function0 & Serializable)() -> {
            if ($this.cacheDataServices != null && !$this.cacheDataServices.isEmpty()) {
                $this.cacheDataServices.forEach(cacheDataService -> cacheDataService.clear());
                return new WebEndpointResponse(200);
            }
            return new WebEndpointResponse(400);
        });
    }

    @DeleteOperation
    public WebEndpointResponse<BoxedUnit> clearCache(@Selector String cacheName) {
        return this.withCacheProviderCheck((Function0 & Serializable)() -> {
            if ($this.cacheDataServices != null && !$this.cacheDataServices.isEmpty()) {
                Option option = CollectionConverters$.MODULE$.ListHasAsScala($this.cacheDataServices).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JCachesEndpoint.$anonfun$clearCache$2(cacheName, x$1)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AppCacheDataService cds = (AppCacheDataService)some.value();
                    cds.clear();
                    return new WebEndpointResponse(200);
                }
                if (None$.MODULE$.equals(option)) {
                    return new WebEndpointResponse(404);
                }
                throw new MatchError((Object)option);
            }
            return new WebEndpointResponse(400);
        });
    }

    private <K> WebEndpointResponse<K> withCacheProviderCheck(Function0<WebEndpointResponse<K>> block) {
        WebEndpointResponse webEndpointResponse;
        block3: {
            try {
                if (this.cacheProvider == null) {
                    webEndpointResponse = new WebEndpointResponse(400);
                    break block3;
                }
                webEndpointResponse = (WebEndpointResponse)block.apply();
            }
            catch (Exception e) {
                this.logger().error((Function0 & Serializable)() -> "Exception occured. " + e.getMessage());
                webEndpointResponse = new WebEndpointResponse(500);
            }
        }
        return webEndpointResponse;
    }

    private List<String> getCaches() {
        ArrayList<String> caches;
        block0: {
            caches = new ArrayList<String>();
            if (this.cacheProvider == null || this.cacheDataServices == null || this.cacheDataServices.isEmpty()) break block0;
            this.cacheDataServices.forEach(cacheDataService -> {
                if (cacheDataService.cacheConfiguration().enabled()) {
                    caches.add(cacheDataService.cacheName());
                    return;
                }
            });
        }
        return caches;
    }

    private Option<CacheDataService<?, ?>> getCacheDataService(String cacheName) {
        if (this.cacheDataServices != null && !this.cacheDataServices.isEmpty()) {
            return CollectionConverters$.MODULE$.ListHasAsScala(this.cacheDataServices).asScala().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JCachesEndpoint.$anonfun$getCacheDataService$1(cacheName, x$2)));
        }
        return None$.MODULE$;
    }

    private Class<?> getCacheDataServiceKeyType(CacheDataService<?, ?> cds) {
        Type[] genericTypes = cds.getClass().getGenericInterfaces();
        Type[] genericType = ((ParameterizedType)genericTypes[0]).getActualTypeArguments();
        return (Class)genericType[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WebEndpointResponse<?> getCacheValue(String key, Class<?> target, CacheDataService<?, ?> cds) {
        None$ none$;
        WebEndpointResponse notFoundResponse = new WebEndpointResponse(null, 404);
        Class<?> clazz = target;
        Class<?> clazz2 = target;
        Class<Integer> clazz3 = Integer.class;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Integer.valueOf(key));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Integer value = (Integer)success.value();
                none$ = cds.get(value);
            } else {
                Failure failure;
                if (!(try_ instanceof Failure) || !((failure = (Failure)try_).exception() instanceof NumberFormatException)) throw new MatchError((Object)try_);
                none$ = None$.MODULE$;
            }
        } else {
            Class<?> clazz4 = target;
            Class<String> clazz5 = String.class;
            if (clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null) throw new Exception("Unknown type for key");
            none$ = cds.get(key);
        }
        None$ result = none$;
        if (!result.isDefined()) return notFoundResponse;
        return new WebEndpointResponse(result.get(), 200);
    }

    public static final /* synthetic */ boolean $anonfun$clearCache$2(String cacheName$2, AppCacheDataService x$1) {
        return x$1.cacheName().equals(cacheName$2);
    }

    public static final /* synthetic */ boolean $anonfun$getCacheDataService$1(String cacheName$3, AppCacheDataService x$2) {
        return x$2.cacheName().equals(cacheName$3);
    }

    public JCachesEndpoint(@Autowired CachesProperties cachesProperties, @Autowired(required=false) CacheProvider cacheProvider, @Autowired List<AppCacheDataService<?, ?>> cacheDataServices) {
        this.cachesProperties = cachesProperties;
        this.cacheProvider = cacheProvider;
        this.cacheDataServices = cacheDataServices;
        Logging.$init$((Logging)this);
    }
}

