package ai.digital.deploy.cache.config

import ai.digital.configuration.central.deploy.CachesProperties
import io.github.resilience4j.circuitbreaker.{CircuitBreaker, CircuitBreakerConfig, CircuitBreakerRegistry}
import org.springframework.context.annotation.{Bean, Configuration}

import java.time.Duration

@Configuration
class CacheCircuitBreakerConfiguration(cachesProperties: CachesProperties) {

  private val circuitBreakerPropertiesConfig = cachesProperties.appCaches.circuitBreakerConfiguration

  private val circuitBreakerConfig = CircuitBreakerConfig.custom()
    .failureRateThreshold(circuitBreakerPropertiesConfig.failureRateThresholdInPercentage)
    .waitDurationInOpenState(Duration.ofSeconds(circuitBreakerPropertiesConfig.waitDurationInOpenStateInSeconds))
    .minimumNumberOfCalls(circuitBreakerPropertiesConfig.minimumNumberOfCalls)
    .slidingWindowSize(circuitBreakerPropertiesConfig.slidingWindowSize)
    .permittedNumberOfCallsInHalfOpenState(circuitBreakerPropertiesConfig.permittedNumberOfCallsInHalfOpenState)
    .ignoreExceptions(classOf[NullPointerException])
    .build()

  private val circuitBreakerRegistry = CircuitBreakerRegistry.of(circuitBreakerConfig)

  @Bean
  def circuitBreaker: CircuitBreaker = circuitBreakerRegistry.circuitBreaker("cacheCircuitBreaker")

}
