package ai.digital.deploy.cache.config

import grizzled.slf4j.Logging
import javax.cache.event.CacheEntryEvent
import javax.cache.event.CacheEntryExpiredListener
import java.lang
import scala.jdk.CollectionConverters._

class CacheEntryExpiredListenerImpl[K, V] extends CacheEntryExpiredListener[K, V] with Logging {

  override def onExpired(events: lang.Iterable[CacheEntryEvent[_ <: K, _ <: V]]): Unit = {
    try {
      events.asScala.foreach(cacheEntryEvent =>
        logger.debug(s"Entry key ${cacheEntryEvent.getKey} expired from cache ${cacheEntryEvent.getSource.getName}"))
    } catch {
      case exception: Exception =>
        logger.error(s"Exception occurred , $exception")
    }
  }
}
