package com.xebialabs.deployit.deployment.planner;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.NonRemotableExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;

import static com.xebialabs.deployit.deployment.ChangeSetBuilder.determineChanges;
import static com.xebialabs.deployit.engine.spi.execution.Transitions.checkTransition;

@SuppressWarnings("serial")
public class ReferentialIntegrityTrigger implements NonRemotableExecutionStateListener {
    private MultiDeltaSpecification fullSpec;

    public ReferentialIntegrityTrigger(MultiDeltaSpecification fullSpec) {
        this.fullSpec = fullSpec;
    }

    @Override
    public void stepStateChanged(StepExecutionStateEvent event) {
    }

    @Override
    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (checkTransition(event, TaskExecutionState.PENDING, TaskExecutionState.EXECUTING)) {
            checkReferentialIntegrity(determineChanges(fullSpec));
        }
    }

    private void checkReferentialIntegrity(ChangeSet changeSet) {
        new ContainersToEnvironmentContributor().contribute(fullSpec, changeSet, null);
        RepositoryServiceHolder.getRepositoryService().checkReferentialIntegrity(changeSet);
    }

}
