/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.List;
import java.util.Map;

public class TestInspectionContext
implements InspectionContext {
    private final Map<String, ConfigurationItem> discovered = Maps.newLinkedHashMap();
    private final Map<String, ConfigurationItem> inspected = Maps.newLinkedHashMap();
    private final List<Step> steps = Lists.newArrayList();

    public void discovered(ConfigurationItem item) {
        Checks.checkArgument((item.getId() != null ? 1 : 0) != 0, (String)"Discovered configuration item must have an id set.", (Object[])new Object[0]);
        this.discovered.put(item.getId(), item);
        Inspector.inspect((ConfigurationItem)item, (InspectionContext)this);
    }

    public Map<String, ConfigurationItem> getDiscovered() {
        return this.discovered;
    }

    public void inspected(ConfigurationItem item) {
        this.discovered.remove(item.getId());
        this.inspected.put(item.getId(), item);
    }

    public Map<String, ConfigurationItem> getInspected() {
        return this.inspected;
    }

    public void addStep(Step step) {
        this.steps.add(step);
    }

    public List<Step> getSteps() {
        return this.steps;
    }
}

