/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;

public class ItestTopology {
    private String id;
    private Set<String> tags = Sets.newHashSet();
    private boolean enabledByDefault = false;
    private Map<String, ConfigurationItem> items = Maps.newHashMap();
    private List<Container> targets = Lists.newArrayList();
    private Map<String, Map<String, String>> targetProperties = Maps.newHashMap();
    private Map<String, String> placeholders = Maps.newHashMap();

    private ItestTopology(Element topologyElement) {
        this.init(topologyElement);
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public List<Container> getTargets() {
        return this.targets;
    }

    public Map<String, Map<String, String>> getTargetProperties() {
        return this.targetProperties;
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public Map<String, ConfigurationItem> getItems() {
        return this.items;
    }

    public String replacePlaceholders(String template) {
        for (String placeholder : this.placeholders.keySet()) {
            template = template.replace("${" + placeholder + "}", this.placeholders.get(placeholder));
        }
        return template;
    }

    public Map<String, String> getTargetProperties(String targetId) {
        Map<String, String> props = this.targetProperties.get(targetId);
        if (props == null) {
            props = Collections.emptyMap();
        }
        return props;
    }

    public String getTargetProperty(String targetId, String propertyName) {
        Map<String, String> props = this.targetProperties.get(targetId);
        if (props != null) {
            return props.get(propertyName);
        }
        return null;
    }

    public boolean hasMatchingTarget(Type type) {
        for (Container target : this.targets) {
            if (!target.getType().instanceOf(type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingCi(Type type) {
        for (ConfigurationItem item : this.items.values()) {
            if (!item.getType().instanceOf(type)) continue;
            return true;
        }
        return false;
    }

    public ConfigurationItem findFirstMatchingCi(Type type) {
        for (ConfigurationItem item : this.items.values()) {
            if (!item.getType().instanceOf(type)) continue;
            return item;
        }
        throw new RuntimeException("Cannot resolve type " + String.valueOf(type) + " to a configuration item in the topology");
    }

    public Container findFirstMatchingTarget(Type type) {
        for (Container target : this.targets) {
            if (!target.getType().instanceOf(type)) continue;
            return target;
        }
        throw new RuntimeException("Cannot resolve type " + String.valueOf(type) + " to a container in the topology");
    }

    public void registerIp(String ip) {
        this.registerIp(this.id, ip);
    }

    public void registerIp(String key, String ip) {
        String fixed;
        Type SSH_HOST = Type.valueOf((String)"overthere.SshHost");
        Type CIFS_HOST = Type.valueOf((String)"overthere.CifsHost");
        Type SSH_JUMP_STATION = Type.valueOf((String)"overthere.SshJumpstation");
        String placeHolder = String.format("${%s}", key);
        for (Map.Entry<String, ConfigurationItem> entry : this.items.entrySet()) {
            ConfigurationItem ci = entry.getValue();
            if (!ci.getType().instanceOf(SSH_HOST) && !ci.getType().instanceOf(SSH_JUMP_STATION) && !ci.getType().instanceOf(CIFS_HOST)) continue;
            String address = (String)ci.getProperty("address");
            fixed = address.replace(placeHolder, ip);
            ci.setProperty("address", (Object)fixed);
        }
        for (Map.Entry<String, Object> entry : this.targetProperties.entrySet()) {
            Map props = (Map)entry.getValue();
            if (!props.containsKey("applicationUrl")) continue;
            String appUrl = (String)props.get("applicationUrl");
            fixed = appUrl.replace(placeHolder, ip);
            props.put("applicationUrl", fixed);
        }
    }

    public static boolean isItestEnabled(String itestName, boolean defaultValue) {
        String enabledItestsSpecification = System.getProperty("itests");
        if (Strings.isBlank((String)enabledItestsSpecification)) {
            return defaultValue;
        }
        Iterable enabledItests = Splitter.on((CharMatcher)CharMatcher.whitespace()).split((CharSequence)enabledItestsSpecification);
        return Iterables.contains((Iterable)enabledItests, (Object)itestName);
    }

    public static Map<String, ItestTopology> load() {
        return ItestTopology.load(ItestTopology.getTopologyItestFile());
    }

    public static Map<String, ItestTopology> load(File file) {
        HashMap topologies = Maps.newHashMap();
        SAXBuilder sb = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        Document topologyXml = null;
        try {
            topologyXml = sb.build(file);
        }
        catch (JDOMException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List topElements = topologyXml.getRootElement().getChildren("toplogy");
        if (topElements.isEmpty()) {
            topElements = topologyXml.getRootElement().getChildren("topology");
        }
        for (Element topElement : topElements) {
            ItestTopology t = new ItestTopology(topElement);
            topologies.put(t.id, t);
        }
        return topologies;
    }

    private static File getTopologyItestFile() {
        URL url = Thread.currentThread().getContextClassLoader().getResource("ItestTopology.xml");
        Objects.requireNonNull(url);
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void init(Element topologyElement) {
        Element placeholdersElement;
        this.id = Objects.requireNonNull(topologyElement.getAttributeValue("id"));
        String enabledString = topologyElement.getAttributeValue("enableByDefault");
        this.enabledByDefault = enabledString != null && enabledString.equals("true");
        String tagsString = topologyElement.getAttributeValue("tags");
        if (Strings.isNotBlank((String)tagsString)) {
            this.tags = Sets.newHashSet((Iterable)Splitter.on((char)',').trimResults().split((CharSequence)tagsString));
        }
        Element configurationItemsElement = topologyElement.getChild("configurationItems");
        Checks.checkNotNull((Object)configurationItemsElement, (String)"configurationItems element required.");
        List ciElements = configurationItemsElement.getChildren();
        for (Element ciElement : ciElements) {
            this.registerCi(ciElement);
        }
        for (Element ciElement : ciElements) {
            this.registerCiProperties(ciElement);
        }
        Element targetsElement = topologyElement.getChild("targets");
        if (targetsElement != null) {
            List targetElements = targetsElement.getChildren();
            for (Element targetElement : targetElements) {
                this.registerTarget(targetElement);
            }
        }
        if ((placeholdersElement = topologyElement.getChild("placeholders")) != null) {
            List placeholderElements = placeholdersElement.getChildren();
            for (Element pElement : placeholderElements) {
                this.placeholders.put(pElement.getName(), Objects.requireNonNull(pElement.getValue()).trim());
            }
        }
        this.resolveParentChildRelationships();
    }

    private void resolveParentChildRelationships() {
        for (ConfigurationItem item : this.items.values()) {
            this.resolveParentChildRelationship(item);
        }
    }

    private void registerTarget(Element targetElement) {
        ConfigurationItem target = this.resolveCiReference(Objects.requireNonNull(targetElement.getAttributeValue("id"), "id is required for target element"), targetElement.getName());
        Descriptor d = DescriptorRegistry.getDescriptor((Type)target.getType());
        Checks.checkArgument((boolean)d.isAssignableTo(Container.class), (String)"Type [%s] is not assignable to udm.Container", (Object[])new Object[]{d.getType()});
        this.targets.add((Container)target);
        for (Element p : targetElement.getChildren()) {
            if (!this.targetProperties.containsKey(target.getId())) {
                this.targetProperties.put(target.getId(), new HashMap());
            }
            Map<String, String> props = this.targetProperties.get(target.getId());
            props.put(p.getName(), Objects.requireNonNull(p.getValue()).trim());
        }
    }

    private void registerCi(Element ciElement) {
        Descriptor d = DescriptorRegistry.getDescriptor((String)ciElement.getName());
        String id = (String)Checks.checkNotNull((Object)ciElement.getAttributeValue("id"), (String)"Element [%s] has no id attribute", (Object[])new Object[]{ciElement.getName()});
        ConfigurationItem item = d.newInstance(id);
        this.items.put(item.getId(), item);
    }

    private void registerCiProperties(Element ciElement) {
        Descriptor d = DescriptorRegistry.getDescriptor((String)ciElement.getName());
        String id = ciElement.getAttributeValue("id");
        ConfigurationItem item = this.items.get(id);
        block8: for (Element p : ciElement.getChildren()) {
            PropertyDescriptor pd = (PropertyDescriptor)Checks.checkNotNull((Object)d.getPropertyDescriptor(p.getName()), (String)"Property [%s.%s] does not exist", (Object[])new Object[]{d.getType(), p.getName()});
            switch (pd.getKind()) {
                case CI: {
                    pd.set(item, (Object)this.resolveCiReference(p));
                    continue block8;
                }
                case MAP_STRING_STRING: {
                    HashMap map = Maps.newHashMap();
                    for (Element e : p.getChildren("entry")) {
                        map.put(Objects.requireNonNull(e.getAttributeValue("key")), Objects.requireNonNull(e.getValue()));
                    }
                    pd.set(item, (Object)map);
                    continue block8;
                }
                case SET_OF_STRING: {
                    HashSet setOfString = Sets.newHashSet();
                    pd.set(item, this.extractElementValuesIntoCollection(p, setOfString));
                    continue block8;
                }
                case LIST_OF_STRING: {
                    ArrayList listOfString = Lists.newArrayList();
                    pd.set(item, this.extractElementValuesIntoCollection(p, listOfString));
                    continue block8;
                }
                case SET_OF_CI: {
                    HashSet setOfCi = Sets.newHashSet();
                    pd.set(item, this.extractElementRefValuesIntoCollection(p, setOfCi));
                    continue block8;
                }
                case LIST_OF_CI: {
                    ArrayList listOfCi = Lists.newArrayList();
                    pd.set(item, this.extractElementRefValuesIntoCollection(p, listOfCi));
                    continue block8;
                }
            }
            pd.set(item, (Object)(p.getAttributeValue("null") != null ? null : p.getValue()));
        }
    }

    private Collection<ConfigurationItem> extractElementRefValuesIntoCollection(Element p, Collection<ConfigurationItem> col) {
        for (Element v : p.getChildren("value")) {
            col.add(this.resolveCiReference(v));
        }
        return col;
    }

    private Collection<String> extractElementValuesIntoCollection(Element p, Collection<String> col) {
        for (Element v : p.getChildren("value")) {
            col.add(v.getValue());
        }
        return col;
    }

    private ConfigurationItem resolveCiReference(Element p) {
        return this.resolveCiReference(p.getValue(), p.getName());
    }

    private ConfigurationItem resolveCiReference(String id, String elementName) {
        String ciRefId = id.trim();
        ConfigurationItem ciRef = this.items.get(ciRefId);
        return (ConfigurationItem)Checks.checkNotNull((Object)ciRef, (String)"Cannot resolve ci ref [%s] for element [%s]", (Object[])new Object[]{ciRefId, elementName});
    }

    private void resolveParentChildRelationship(ConfigurationItem item) {
        Descriptor d = DescriptorRegistry.getDescriptor((Type)item.getType());
        for (PropertyDescriptor pd : d.getPropertyDescriptors()) {
            boolean isReferenceToParent = pd.getKind() == PropertyKind.CI && pd.isAsContainment();
            if (!isReferenceToParent) continue;
            ConfigurationItem parent = this.getParent(item, pd);
            pd.set(item, (Object)parent);
            for (PropertyDescriptor ppd : parent.getType().getDescriptor().getPropertyDescriptors()) {
                boolean isReferenceToChild = (ppd.getKind() == PropertyKind.SET_OF_CI || ppd.getKind() == PropertyKind.LIST_OF_CI) && ppd.isAsContainment() && d.isAssignableTo(ppd.getReferencedType());
                if (!isReferenceToChild) continue;
                Collection refs = (Collection)ppd.get(parent);
                refs.add(item);
                ppd.set(parent, (Object)refs);
            }
        }
    }

    private ConfigurationItem getParent(ConfigurationItem item, PropertyDescriptor pd) {
        ConfigurationItem parent;
        String parentId = this.getParentId(item.getId());
        if (parentId.equals(item.getId())) {
            parent = item;
        } else {
            parent = this.items.get(parentId);
            Checks.checkArgument((parent != null ? 1 : 0) != 0, (String)"Cannot resolve parent reference from item [%s] for property [%s]", (Object[])new Object[]{item.getId(), pd});
        }
        return parent;
    }

    private String getParentId(String id) {
        int indexOfLastSlash = id.lastIndexOf(47);
        Checks.checkArgument((indexOfLastSlash != -1 ? 1 : 0) != 0, (String)"[%s] has no parent", (Object[])new Object[]{id});
        return id.substring(0, indexOfLastSlash);
    }
}

