package ai.digital.deploy.jython.cache

import ai.digital.configuration.central.deploy.{CacheConfiguration, CachesProperties}
import ai.digital.deploy.cache.config.CacheProvider
import ai.digital.deploy.cache.service.{SystemCacheDataService}
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.stereotype.Service

import javax.script.CompiledScript

@Service
class DeployJythonCacheDataService (@Autowired(required = false) @Qualifier("defaultEmbeddedCacheProvider") override val cacheProvider: CacheProvider,
                                    @Autowired cachesProperties: CachesProperties) extends SystemCacheDataService[String, CompiledScript] {
  override val cacheName: String = "JYTHON_SCRIPT"
  override val cacheConfiguration: CacheConfiguration = cachesProperties.systemCaches.jythonScriptCacheConfiguration

}