package ai.digital.deploy.jython.script.engine

import ai.digital.deploy.jython.cache.{DeployJythonCacheDataService}
import com.xebialabs.platform.script.jython.EngineInstance
import org.python.jsr223.PyScriptEngine
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.stereotype.Component

import java.io.Reader
import javax.script.{Bindings, CompiledScript, ScriptContext, ScriptEngine, ScriptEngineFactory, ScriptEngineManager}

@ConditionalOnProperty(prefix="deploy.caches.system-caches", name = Array("enabled", "jython-script-cache-configuration.enabled"), havingValue = "true")
@Component
class DeployJythonScriptEngine (@Autowired deployJythonCacheDataService: DeployJythonCacheDataService ) extends ScriptEngine {
  private final val defaultEngine = new ScriptEngineManager(EngineInstance.getClass.getClassLoader)
    .getEngineByName("python").asInstanceOf[PyScriptEngine]

  override def eval(script: String, scriptContext: ScriptContext): AnyRef = {
    val compiledScript = deployJythonCacheDataService.get(script).getOrElse[CompiledScript]({
      val complied = defaultEngine.compile(script)
      deployJythonCacheDataService.put(script, complied)
      complied
    })
    compiledScript.eval(scriptContext)
  }

  override def eval(reader: Reader, scriptContext: ScriptContext): AnyRef = {
    defaultEngine.eval(reader,scriptContext)
  }

  override def eval(s: String): AnyRef = defaultEngine.eval(s)

  override def eval(reader: Reader): AnyRef = defaultEngine.eval(reader)

  override def eval(s: String, bindings: Bindings): AnyRef = defaultEngine.eval(s,bindings)

  override def eval(reader: Reader, bindings: Bindings): AnyRef = defaultEngine.eval(reader,bindings)

  override def put(s: String, o: Any): Unit = defaultEngine.put(s,o)

  override def get(s: String): AnyRef = defaultEngine.get(s)

  override def getBindings(i: Int): Bindings = defaultEngine.getBindings(i)

  override def setBindings(bindings: Bindings, i: Int): Unit = defaultEngine.setBindings(bindings,i)

  override def createBindings(): Bindings = defaultEngine.createBindings()

  override def getContext: ScriptContext = defaultEngine.getContext

  override def setContext(scriptContext: ScriptContext): Unit = defaultEngine.setContext(scriptContext)

  override def getFactory: ScriptEngineFactory = defaultEngine.getFactory
}
