package ai.digital.deploy.jython.script.engine

import com.xebialabs.platform.script.jython.EngineInstance
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.concurrent.atomic.AtomicReference
import javax.script.ScriptEngine

@Component
class DeployJythonScriptEngineHolder(@Autowired(required = false) deployJythonScriptEngine: ScriptEngine) {
  DeployJythonScriptEngineHolder.deployJythonScriptEngine.set(deployJythonScriptEngine)
}

object DeployJythonScriptEngineHolder {

  private val deployJythonScriptEngine = new AtomicReference[ScriptEngine]

  def getDeployJythonScriptEngine: ScriptEngine =
    if(DeployJythonScriptEngineHolder.deployJythonScriptEngine.get()!=null) {
      DeployJythonScriptEngineHolder.deployJythonScriptEngine.get()
    } else {
      EngineInstance.jython
    }
}
