package ai.digital.deploy.permissions.client

import ai.digital.deploy.permissions.api.rest.dto.{RoleDto, RoleWithPrincipalsDto}
import ai.digital.deploy.permissions.client.util.SortOrder

import java.util.UUID

trait RoleServiceClient {
  def getAll: List[RoleDto]

  def create(name: String, principals: List[String]): RoleWithPrincipalsDto

  def createOrUpdate(role: RoleDto): RoleDto

  def update(originalRoleName: String,
             updatedRoleName: String,
             principalsToCreate: Set[String],
             principalsToDelete: Set[String]
  ): RoleWithPrincipalsDto

  def create(name: String): RoleDto

  def update(id: UUID, roleName: String): RoleDto

  def rename(name: String, newName: String): RoleDto

  def delete(roleName: String): Unit

  def deleteById(roleId: String): Unit

  def read(roleName: String): Option[RoleDto]

  def read(namePattern: String, page: Int, size: Int, order: SortOrder, field: String): PaginatedResponse[RoleDto]

  def readByRolePattern(namePattern: String): List[RoleDto]

  def readById(roleId: String): Option[RoleDto]

  def removeAllReferences(roleName: String): Unit

  def removeAll(): Unit

  def roleExists(roleName: String): Boolean

  def countRoles(roleNamePattern: String): Long
}
