package ai.digital.deploy.permissions.client.local

import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter._
import ai.digital.deploy.permissions.api.rest.dto.RoleDto
import ai.digital.deploy.permissions.client.{PaginatedResponse, PrincipalRolesServiceClient}
import ai.digital.deploy.permissions.client.util.SortOrder
import ai.digital.deploy.permissions.client.{PaginatedResponse, PrincipalRolesServiceClient}
import ai.digital.deploy.permissions.config.profile.PermissionServiceProfileConfig.EmbeddedPermissionServiceProfile
import ai.digital.deploy.permissions.jpa.{ReadOnlyTransactionalPermissionService, TransactionalPermissionService}
import ai.digital.deploy.permissions.service.RolePrincipalService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.annotation.Profile
import org.springframework.data.domain.PageRequest
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@ConditionalOnProperty(name = Array("xl.permission-service.enabled"), havingValue = "true", matchIfMissing = true)
@Service
@Profile(Array(EmbeddedPermissionServiceProfile))
@TransactionalPermissionService
class LocalPrincipalRolesServiceClient(@Autowired rolePrincipalService: RolePrincipalService)
    extends PrincipalRolesServiceClient {
  @ReadOnlyTransactionalPermissionService
  override def read(principal: String): List[RoleDto] =
    rolePrincipalService.read(principal).map(rp => RoleDto(rp.role.id, rp.role.name))

  @ReadOnlyTransactionalPermissionService
  override def read(principal: String,
                    namePattern: String,
                    page: Int,
                    size: Int,
                    order: SortOrder,
                    field: String
  ): PaginatedResponse[RoleDto] = {
    val resultPage = rolePrincipalToDto(
      rolePrincipalService.read(principal, namePattern, PageRequest.of(page - 1, size, SortOrder.getSort(order, field)))
    )
    PaginatedResponse[RoleDto](
      resultPage.getContent.asScala.toList,
      resultPage.getTotalElements,
      page,
      size,
      resultPage.hasNext
    )
  }
}
