package ai.digital.deploy.permissions.client

import ai.digital.deploy.permissions.api.rest.dto.{PermissionFilterDto, RoleWithReferencedPermissionsDto}
import ai.digital.deploy.permissions.client.util.SortOrder

import java.util.UUID

trait ReferencedPermissionServiceClient {
  def read(referenceId: UUID, roleName: String): List[String]

  def read(referenceId: UUID,
           rolePattern: String,
           page: Int,
           size: Int,
           order: SortOrder,
           field: String
  ): PaginatedResponse[RoleWithReferencedPermissionsDto]

  def readByRolePattern(
    referenceId: UUID,
    rolePattern: String
  ): List[RoleWithReferencedPermissionsDto]

  def addPermissions(referenceId: UUID, role: String, permissions: List[String]): RoleWithReferencedPermissionsDto

  def removePermissions(referenceId: UUID, roleName: String, permissions: List[String]): RoleWithReferencedPermissionsDto

  def getReferencesForRole(roleId: UUID, permissions: List[String]): Set[UUID]

  def getReferencesForRoleName(roleName: String, permissions: List[String]): Set[UUID]

  def getReferencesForPrincipal(principalName: String, permissions: List[String]): Set[UUID]
}
