package ai.digital.deploy.permissions.client.local.logging

import ai.digital.deploy.permissions.api.rest.dto.{PermissionFilterDto, RoleWithReferencedPermissionsDto}
import ai.digital.deploy.permissions.client.{PaginatedResponse, ReferencedPermissionServiceClient}
import ai.digital.deploy.permissions.client.util.SortOrder
import ai.digital.deploy.permissions.config.profile.PermissionServiceProfileConfig.EmbeddedPermissionServiceProfile
import grizzled.slf4j.Logging
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.annotation.Profile
import org.springframework.stereotype.Service

import java.util.UUID

@ConditionalOnProperty(name = Array("xl.permission-service.enabled"), havingValue = "false")
@Service
@Profile(Array(EmbeddedPermissionServiceProfile))
class LoggingReferencePermissionServiceClient extends ReferencedPermissionServiceClient with Logging {
  override def read(referenceId: UUID, roleName: String): List[String] = {
    debug("Called read - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def read(referenceId: UUID,
                    rolePattern: String,
                    page: Int,
                    size: Int,
                    order: SortOrder,
                    field: String
  ): PaginatedResponse[RoleWithReferencedPermissionsDto] = {
    debug("Called paginated read - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def addPermissions(referenceId: UUID, role: String, permissions: List[String]): RoleWithReferencedPermissionsDto = {
    debug("Called addPermissions - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def removePermissions(referenceId: UUID,
                                 roleName: String,
                                 permissions: List[String]
  ): RoleWithReferencedPermissionsDto = {
    debug("Called removePermissions - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def getReferencesForRole(roleId: UUID, permissions: List[String]): Set[UUID] = {
    debug("Called getReferencesForRole - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def getReferencesForRoleName(roleName: String, permissions: List[String]): Set[UUID] = {
    debug("Called getReferencesForRoleName - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def getReferencesForPrincipal(principalName: String, permissions: List[String]): Set[UUID] = {
    debug("Called getReferencesForPrincipal - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def readByRolePattern(referenceId: UUID, rolePattern: String): List[RoleWithReferencedPermissionsDto] = {
    debug("Called readByRolePattern - void implementation")
    throw PermissionServiceNotImplementedException()
  }

}
