package ai.digital.deploy.permissions.client.remote

import ai.digital.deploy.permissions.api.rest.dto.RoleDto
import ai.digital.deploy.permissions.api.rest.pagination.{Order, Paging}
import ai.digital.deploy.permissions.api.rest.v1.PrincipalRolesPaths
import ai.digital.deploy.permissions.client.{PaginatedResponse, PrincipalRolesServiceClient}
import ai.digital.deploy.permissions.client.util.SortOrder
import ai.digital.deploy.permissions.config.profile.PermissionServiceProfileConfig.NotEmbeddedPermissionServiceProfile
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.Profile
import org.springframework.http.HttpMethod
import org.springframework.stereotype.Component
import org.springframework.web.client.RestTemplate
import org.springframework.web.util.UriComponentsBuilder

@Component
@Profile(Array(NotEmbeddedPermissionServiceProfile))
class RemotePrincipalRolesServiceClient(@Autowired restTemplate: RestTemplate)
    extends BaseRemoteClient
    with PrincipalRolesServiceClient {
  private val basePath = permissionServiceUrl + PrincipalRolesPaths.BASE_PATH
  private val readRoles = basePath + PrincipalRolesPaths.READ_PRINCIPAL_ROLES_PATH
  private val readRolesByNamePattern = basePath + PrincipalRolesPaths.READ_PRINCIPAL_ROLES_PATH_BY_PATTERN

  override def read(principal: String): List[RoleDto] =
    restTemplate.getForObject(readRoles, classOf[Array[RoleDto]], principal).toList

  override def read(principal: String,
                    rolePattern: String,
                    page: Int,
                    size: Int,
                    order: SortOrder,
                    field: String
  ): PaginatedResponse[RoleDto] = {
    val uri = UriComponentsBuilder
      .fromUriString(readRolesByNamePattern)
      .queryParam("namePattern", rolePattern)
      .queryParam(Paging.PAGE_PARAMETER, page)
      .queryParam(Paging.SIZE_PARAMETER, size)
      .queryParam(Order.ORDER_PARAMETER, s"$field:${order.value}")
      .build(principal)
    val response = restTemplate.exchange(uri, HttpMethod.GET, null, classOf[Array[RoleDto]])
    val headers = response.getHeaders
    PaginatedResponse(
      response.getBody.toList,
      headers.getFirst(Paging.X_TOTAL_COUNT_HEADER).toLong,
      headers.getFirst(Paging.X_PAGE).toInt,
      headers.getFirst(Paging.X_SIZE).toInt,
      headers.getFirst(Paging.X_HAS_NEXT_PAGE_HEADER).toBoolean
    )
  }
}
