package ai.digital.deploy.permissions.client.local.logging

import ai.digital.deploy.permissions.api.rest.dto.RoleWithGlobalPermissionsDto
import ai.digital.deploy.permissions.client.util.SortOrder
import ai.digital.deploy.permissions.client.{GlobalPermissionsServiceClient, PaginatedResponse}
import ai.digital.deploy.permissions.config.profile.PermissionServiceProfileConfig.EmbeddedPermissionServiceProfile
import grizzled.slf4j.Logging
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.annotation.Profile
import org.springframework.stereotype.Service

@ConditionalOnProperty(name = Array("xl.permission-service.enabled"), havingValue = "false")
@Service
@Profile(Array(EmbeddedPermissionServiceProfile))
class LoggingGlobalPermissionsServiceClient extends GlobalPermissionsServiceClient with Logging {
  override def addPermissions(roleName: String, permissions: List[String]): RoleWithGlobalPermissionsDto = {
    debug("Called addPermissions - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def removePermissions(roleName: String, permissions: List[String]): RoleWithGlobalPermissionsDto = {
    debug("Called removePermissions - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def read(roleName: String): List[String] = {
    debug("Called read - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def read(rolePattern: String,
                    page: Int,
                    size: Int,
                    order: SortOrder,
                    field: String
  ): PaginatedResponse[RoleWithGlobalPermissionsDto] = {
    debug("Called paginated read - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def getGlobalPermissionsForRoleId(roleId: String): List[String] = {
    debug("Called getGlobalPermissionsForRoleId - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def getGlobalPermissionsForPrincipal(principalName: String): Set[String] = {
    debug("Called getGlobalPermissionsForPrincipal - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def getGlobalPermissionsForRoles(roleNames: List[String]): List[RoleWithGlobalPermissionsDto] = {
    debug("Called getGlobalPermissionsForRoles - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def readByRolePattern(rolePattern: String): List[RoleWithGlobalPermissionsDto] = {
    debug("Called readByRolePattern - void implementation")
    throw PermissionServiceNotImplementedException()
  }
}
