/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.client.local;

import ai.digital.deploy.permissions.api.rest.dto.RoleDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithPrincipalsDto;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.client.PaginatedResponse;
import ai.digital.deploy.permissions.client.RoleServiceClient;
import ai.digital.deploy.permissions.client.util.SortOrder;
import ai.digital.deploy.permissions.client.util.SortOrder$;
import ai.digital.deploy.permissions.exception.RoleNameAlreadyExistsException;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.jpa.ReadOnlyTransactionalPermissionService;
import ai.digital.deploy.permissions.jpa.TransactionalPermissionService;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.model.Role$;
import ai.digital.deploy.permissions.service.RoleNameAlreadyExistsServiceException;
import ai.digital.deploy.permissions.service.RoleNameNotFoundServiceException;
import ai.digital.deploy.permissions.service.RolePrincipalService;
import ai.digital.deploy.permissions.service.RoleService;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Component
@ConditionalOnProperty(name={"xl.permission-service.enabled"}, havingValue="true", matchIfMissing=true)
@Profile(value={"permission-service"})
@TransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\t5b\u0001B\u000b\u0017\u0001\rB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\")\u0011\n\u0001C\u0001\u0015\")\u0011\u000b\u0001C!%\")\u0001\u000f\u0001C!c\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011\u0019\u0001\b\u0001\"\u0011\u00026!9\u0011Q\u0002\u0001\u0005B\u0005e\u0002bBA)\u0001\u0011\u0005\u00131\u000b\u0005\b\u00037\u0002A\u0011IA/\u0011\u001d\t\t\u0007\u0001C!\u0003GBq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002x\u0001!\t%!\u001f\t\u000f\u0005]\u0004\u0001\"\u0011\u0002\u0002\"9\u0011q\u0016\u0001\u0005B\u0005E\u0006bBA\\\u0001\u0011\u0005\u0013\u0011\u0018\u0005\b\u0003w\u0003A\u0011IA_\u0011\u001d\tI\r\u0001C!\u0003\u0017\u0014a\u0003T8dC2\u0014v\u000e\\3TKJ4\u0018nY3DY&,g\u000e\u001e\u0006\u0003/a\tQ\u0001\\8dC2T!!\u0007\u000e\u0002\r\rd\u0017.\u001a8u\u0015\tYB$A\u0006qKJl\u0017n]:j_:\u001c(BA\u000f\u001f\u0003\u0019!W\r\u001d7ps*\u0011q\u0004I\u0001\bI&<\u0017\u000e^1m\u0015\u0005\t\u0013AA1j\u0007\u0001\u00192\u0001\u0001\u0013+!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fMB\u00111\u0006L\u0007\u00021%\u0011Q\u0006\u0007\u0002\u0012%>dWmU3sm&\u001cWm\u00117jK:$\u0018a\u0003:pY\u0016\u001cVM\u001d<jG\u0016\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u000e\u0002\u000fM,'O^5dK&\u0011A'\r\u0002\f%>dWmU3sm&\u001cW\r\u000b\u0002\u0002mA\u0011qGQ\u0007\u0002q)\u0011\u0011HO\u0001\u000bC:tw\u000e^1uS>t'BA\u001e=\u0003\u001d1\u0017m\u0019;pefT!!\u0010 \u0002\u000b\t,\u0017M\\:\u000b\u0005}\u0002\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\u0005\u000b1a\u001c:h\u0013\t\u0019\u0005HA\u0005BkR|w/\u001b:fI\u0006!\"o\u001c7f!JLgnY5qC2\u001cVM\u001d<jG\u0016\u0004\"\u0001\r$\n\u0005\u001d\u000b$\u0001\u0006*pY\u0016\u0004&/\u001b8dSB\fGnU3sm&\u001cW\r\u000b\u0002\u0003m\u00051A(\u001b8jiz\"2aS'P!\ta\u0005!D\u0001\u0017\u0011\u0015q3\u00011\u00010Q\tie\u0007C\u0003E\u0007\u0001\u0007Q\t\u000b\u0002Pm\u00051q-\u001a;BY2,\u0012a\u0015\t\u0004)r{fBA+[\u001d\t1\u0016,D\u0001X\u0015\tA&%\u0001\u0004=e>|GOP\u0005\u0002O%\u00111LJ\u0001\ba\u0006\u001c7.Y4f\u0013\tifL\u0001\u0003MSN$(BA.'!\t\u0001w-D\u0001b\u0015\t\u00117-A\u0002ei>T!\u0001Z3\u0002\tI,7\u000f\u001e\u0006\u0003Mj\t1!\u00199j\u0013\tA\u0017MA\u0004S_2,G\t^8)\u0005\u0011Q\u0007CA6o\u001b\u0005a'BA7\u001b\u0003\rQ\u0007/Y\u0005\u0003_2\u0014aEU3bI>sG.\u001f+sC:\u001c\u0018m\u0019;j_:\fG\u000eU3s[&\u001c8/[8o'\u0016\u0014h/[2f\u0003\u0019\u0019'/Z1uKR\u0019!/^@\u0011\u0005\u0001\u001c\u0018B\u0001;b\u0005U\u0011v\u000e\\3XSRD\u0007K]5oG&\u0004\u0018\r\\:Ei>DQA^\u0003A\u0002]\fAA\\1nKB\u0011\u0001\u0010 \b\u0003sj\u0004\"A\u0016\u0014\n\u0005m4\u0013A\u0002)sK\u0012,g-\u0003\u0002~}\n11\u000b\u001e:j]\u001eT!a\u001f\u0014\t\u000f\u0005\u0005Q\u00011\u0001\u0002\u0004\u0005Q\u0001O]5oG&\u0004\u0018\r\\:\u0011\u0007Qcv/\u0001\bde\u0016\fG/Z(s+B$\u0017\r^3\u0015\u0007}\u000bI\u0001\u0003\u0004\u0002\f\u0019\u0001\raX\u0001\u0005e>dW-\u0001\u0004va\u0012\fG/\u001a\u000b\ne\u0006E\u0011QCA\r\u0003GAa!a\u0005\b\u0001\u00049\u0018\u0001E8sS\u001eLg.\u00197S_2,g*Y7f\u0011\u0019\t9b\u0002a\u0001o\u0006yQ\u000f\u001d3bi\u0016$'k\u001c7f\u001d\u0006lW\rC\u0004\u0002\u001c\u001d\u0001\r!!\b\u0002%A\u0014\u0018N\\2ja\u0006d7\u000fV8De\u0016\fG/\u001a\t\u0005q\u0006}q/C\u0002\u0002\"y\u00141aU3u\u0011\u001d\t)c\u0002a\u0001\u0003;\t!\u0003\u001d:j]\u000eL\u0007/\u00197t)>$U\r\\3uK\u0006\u0019\"/Z7pm\u0016\fE\u000e\u001c*fM\u0016\u0014XM\\2fgR!\u00111FA\u0019!\r)\u0013QF\u0005\u0004\u0003_1#\u0001B+oSRDa!a\r\t\u0001\u00049\u0018\u0001\u0003:pY\u0016t\u0015-\\3\u0015\u0007}\u000b9\u0004C\u0003w\u0013\u0001\u0007q\u000fF\u0003`\u0003w\ty\u0005C\u0004\u0002>)\u0001\r!a\u0010\u0002\u0005%$\u0007\u0003BA!\u0003\u0017j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0005kRLGN\u0003\u0002\u0002J\u0005!!.\u0019<b\u0013\u0011\ti%a\u0011\u0003\tU+\u0016\n\u0012\u0005\u0007\u0003gQ\u0001\u0019A<\u0002\rI,g.Y7f)\u0015y\u0016QKA,\u0011\u001518\u00021\u0001x\u0011\u0019\tIf\u0003a\u0001o\u00069a.Z<OC6,\u0017A\u00023fY\u0016$X\r\u0006\u0003\u0002,\u0005}\u0003BBA\u001a\u0019\u0001\u0007q/\u0001\u0006eK2,G/\u001a\"z\u0013\u0012$B!a\u000b\u0002f!1\u0011qM\u0007A\u0002]\faA]8mK&#\u0017\u0001\u0003:fC\u0012\u0014\u00150\u00133\u0015\t\u00055\u00141\u000f\t\u0005K\u0005=$/C\u0002\u0002r\u0019\u0012aa\u00149uS>t\u0007BBA4\u001d\u0001\u0007q\u000f\u000b\u0002\u000fU\u0006!!/Z1e)\u0011\tY(! \u0011\t\u0015\nyg\u0018\u0005\u0007\u0003gy\u0001\u0019A<)\u0005=QG\u0003DAB\u0003\u0013\u000bi)a&\u0002\u001c\u0006%\u0006\u0003B\u0016\u0002\u0006~K1!a\"\u0019\u0005E\u0001\u0016mZ5oCR,GMU3ta>t7/\u001a\u0005\u0007\u0003\u0017\u0003\u0002\u0019A<\u0002\u00179\fW.\u001a)biR,'O\u001c\u0005\b\u0003\u001f\u0003\u0002\u0019AAI\u0003\u0011\u0001\u0018mZ3\u0011\u0007\u0015\n\u0019*C\u0002\u0002\u0016\u001a\u00121!\u00138u\u0011\u001d\tI\n\u0005a\u0001\u0003#\u000bAa]5{K\"9\u0011Q\u0014\tA\u0002\u0005}\u0015!B8sI\u0016\u0014\b\u0003BAQ\u0003Kk!!a)\u000b\u0007\u0005\u0015\u0003$\u0003\u0003\u0002(\u0006\r&!C*peR|%\u000fZ3s\u0011\u0019\tY\u000b\u0005a\u0001o\u0006)a-[3mI\"\u0012\u0001C[\u0001\u0012e\u0016\fGMQ=S_2,\u0007+\u0019;uKJtGcA*\u00024\"1\u00111R\tA\u0002]D#!\u00056\u0002\u0013I,Wn\u001c<f\u00032dGCAA\u0016\u0003)\u0011x\u000e\\3Fq&\u001cHo\u001d\u000b\u0005\u0003\u007f\u000b)\rE\u0002&\u0003\u0003L1!a1'\u0005\u001d\u0011un\u001c7fC:Da!a\r\u0014\u0001\u00049\bFA\nk\u0003)\u0019w.\u001e8u%>dWm\u001d\u000b\u0005\u0003\u001b\f\u0019\u000eE\u0002&\u0003\u001fL1!!5'\u0005\u0011auN\\4\t\r\u0005UG\u00031\u0001x\u0003=\u0011x\u000e\\3OC6,\u0007+\u0019;uKJt\u0007F\u0001\u000bkQ\r\u0001\u00111\u001c\t\u0004W\u0006u\u0017bAApY\nqBK]1og\u0006\u001cG/[8oC2\u0004VM]7jgNLwN\\*feZL7-\u001a\u0015\b\u0001\u0005\r\u0018\u0011_Az!\u0011\t)/!<\u000e\u0005\u0005\u001d(bA\u001d\u0002j*\u0019\u00111\u001e \u0002\u000f\r|g\u000e^3yi&!\u0011q^At\u0005\u001d\u0001&o\u001c4jY\u0016\fQA^1mk\u0016d#!!>\"\u0005\u0005]\u0018A\u00059fe6L7o]5p]6\u001aXM\u001d<jG\u0016Dc\u0002AA~m\n=!Q\u0003B\f\u00057\u0011i\u0002\u0005\u0003\u0002~\n-QBAA\u0000\u0015\u0011\u0011\tAa\u0001\u0002\u0013\r|g\u000eZ5uS>t'\u0002\u0002B\u0003\u0005\u000f\tQ\"Y;u_\u000e|gNZ5hkJ,'b\u0001B\u0005}\u0005!!m\\8u\u0013\u0011\u0011i!a@\u0003+\r{g\u000eZ5uS>t\u0017\r\\(o!J|\u0007/\u001a:us2\u0012!\u0011C\u0011\u0003\u0005'\tQ\u0004\u001f7/a\u0016\u0014X.[:tS>tWf]3sm&\u001cWML3oC\ndW\rZ\u0001\fQ\u00064\u0018N\\4WC2,X-\t\u0002\u0003\u001a\u0005!AO];f\u00039i\u0017\r^2i\u0013\u001al\u0015n]:j]\u001eL\u0012!\u0001\u0015\u0004\u0001\t\u0005\u0002\u0003\u0002B\u0012\u0005Si!A!\n\u000b\u0007\t\u001db(\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAAa\u000b\u0003&\tI1i\\7q_:,g\u000e\u001e")
public class LocalRoleServiceClient
implements RoleServiceClient {
    @Autowired
    private final RoleService roleService;
    @Autowired
    private final RolePrincipalService rolePrincipalService;

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<RoleDto> getAll() {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.readAll());
    }

    @Override
    public RoleWithPrincipalsDto create(String name, List<String> principals) {
        Right right;
        Tuple2 tuple2;
        this.roleService.create(name);
        Either either = this.rolePrincipalService.add(name, principals);
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            Role role = (Role)tuple2._1();
            List rolePrincipals = (List)tuple2._2();
            return new RoleWithPrincipalsDto(RoleConverter$.MODULE$.roleToDto(role), rolePrincipals.map((Function1 & Serializable)x$1 -> x$1.principalName()));
        }
        throw new MatchError((Object)either);
    }

    @Override
    public RoleDto createOrUpdate(RoleDto role) {
        Either either = this.roleService.createOrUpdate(Role$.MODULE$.apply(role.id(), role.name()));
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameAlreadyExistsServiceException exception = (RoleNameAlreadyExistsServiceException)left.value();
            throw new RoleNameAlreadyExistsException(exception.name());
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Role result = (Role)right.value();
            return RoleConverter$.MODULE$.roleToDto(result);
        }
        throw new MatchError((Object)either);
    }

    @Override
    public RoleWithPrincipalsDto update(String originalRoleName, String updatedRoleName, Set<String> principalsToCreate, Set<String> principalsToDelete) {
        Either either = this.rolePrincipalService.edit(originalRoleName, principalsToCreate.toList(), principalsToDelete.toList());
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (either instanceof Right) {
            Throwable exception;
            Right right = (Right)either;
            Tuple2 principalEditResult = (Tuple2)right.value();
            String string = originalRoleName;
            String string2 = updatedRoleName;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new RoleWithPrincipalsDto(RoleConverter$.MODULE$.roleToDto((Role)principalEditResult._1()), ((List)principalEditResult._2()).map((Function1 & Serializable)x$2 -> x$2.principalName()));
            }
            boolean bl = false;
            Left left = null;
            Either either2 = this.roleService.rename(originalRoleName, updatedRoleName);
            if (either2 instanceof Left) {
                bl = true;
                left = (Left)either2;
                Throwable exception2 = (Throwable)left.value();
                if (exception2 instanceof RoleNameAlreadyExistsServiceException) {
                    RoleNameAlreadyExistsServiceException roleNameAlreadyExistsServiceException = (RoleNameAlreadyExistsServiceException)exception2;
                    throw new RoleNameNotFoundException(roleNameAlreadyExistsServiceException.name());
                }
            }
            if (bl && (exception = (Throwable)left.value()) instanceof RoleNameNotFoundServiceException) {
                RoleNameNotFoundServiceException roleNameNotFoundServiceException = (RoleNameNotFoundServiceException)exception;
                throw new RoleNameAlreadyExistsException(roleNameNotFoundServiceException.name());
            }
            if (either2 instanceof Right) {
                Right right2 = (Right)either2;
                Role updatedRole = (Role)right2.value();
                Either either3 = this.rolePrincipalService.read(updatedRole.name());
                if (either3 instanceof Left) {
                    Left left2 = (Left)either3;
                    RoleNameNotFoundServiceException exception3 = (RoleNameNotFoundServiceException)left2.value();
                    throw new RoleNameNotFoundException(exception3.name());
                }
                if (either3 instanceof Right) {
                    Right right3 = (Right)either3;
                    List principals = (List)right3.value();
                    return new RoleWithPrincipalsDto(RoleConverter$.MODULE$.roleToDto(updatedRole), principals.map((Function1 & Serializable)x$3 -> x$3.principalName()));
                }
                throw new MatchError((Object)either3);
            }
            throw new MatchError((Object)either2);
        }
        throw new MatchError((Object)either);
    }

    @Override
    public void removeAllReferences(String roleName) {
        Either either = this.roleService.deleteAllRoleReferences(roleName);
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (either instanceof Right) {
            return;
        }
        throw new MatchError((Object)either);
    }

    @Override
    public RoleDto create(String name) {
        Either either = this.roleService.create(name);
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameAlreadyExistsServiceException exception = (RoleNameAlreadyExistsServiceException)left.value();
            throw new RoleNameAlreadyExistsException(exception.name());
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Role result = (Role)right.value();
            return RoleConverter$.MODULE$.roleToDto(result);
        }
        throw new MatchError((Object)either);
    }

    @Override
    public RoleDto update(UUID id, String roleName) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.update(Role$.MODULE$.apply(id, roleName)));
    }

    @Override
    public RoleDto rename(String name, String newName) {
        Throwable exception;
        boolean bl = false;
        Left left = null;
        Either either = this.roleService.rename(name, newName);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Throwable exception2 = (Throwable)left.value();
            if (exception2 instanceof RoleNameNotFoundServiceException) {
                RoleNameNotFoundServiceException roleNameNotFoundServiceException = (RoleNameNotFoundServiceException)exception2;
                throw new RoleNameNotFoundException(roleNameNotFoundServiceException.name());
            }
        }
        if (bl && (exception = (Throwable)left.value()) instanceof RoleNameAlreadyExistsServiceException) {
            RoleNameAlreadyExistsServiceException roleNameAlreadyExistsServiceException = (RoleNameAlreadyExistsServiceException)exception;
            throw new RoleNameAlreadyExistsException(roleNameAlreadyExistsServiceException.name());
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Role result = (Role)right.value();
            return RoleConverter$.MODULE$.roleToDto(result);
        }
        throw new MatchError((Object)either);
    }

    @Override
    public void delete(String roleName) {
        this.roleService.delete(roleName);
    }

    @Override
    public void deleteById(String roleId) {
        this.roleService.delete(UUID.fromString(roleId));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Option<RoleWithPrincipalsDto> readById(String roleId) {
        return RoleConverter$.MODULE$.roleToRoleWithPrincipalsDto(this.roleService.read(UUID.fromString(roleId)));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Option<RoleDto> read(String roleName) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.read(roleName));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public PaginatedResponse<RoleDto> read(String namePattern, int page, int size, SortOrder order, String field) {
        Page rolePage = this.roleService.read(namePattern, (Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)SortOrder$.MODULE$.getSort(order, field)));
        return new PaginatedResponse<RoleDto>(RoleConverter$.MODULE$.roleToDto(CollectionConverters$.MODULE$.ListHasAsScala(rolePage.getContent()).asScala().toList()), rolePage.getTotalElements(), page, size, rolePage.hasNext());
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<RoleDto> readByRolePattern(String namePattern) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.readByRolePattern(namePattern));
    }

    @Override
    public void removeAll() {
        this.roleService.removeAll();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public boolean roleExists(String roleName) {
        return this.roleService.read(roleName).isDefined();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public long countRoles(String roleNamePattern) {
        return this.roleService.count(roleNamePattern);
    }

    public LocalRoleServiceClient(@Autowired RoleService roleService, @Autowired RolePrincipalService rolePrincipalService) {
        this.roleService = roleService;
        this.rolePrincipalService = rolePrincipalService;
    }
}

