package ai.digital.deploy.permissions.client

import ai.digital.deploy.permissions.api.rest.dto.RoleWithGlobalPermissionsDto
import ai.digital.deploy.permissions.client.util.SortOrder

trait GlobalPermissionsServiceClient {
  def addPermissions(roleName: String, permissions: List[String]): RoleWithGlobalPermissionsDto
  def removePermissions(roleName: String, permissions: List[String]): RoleWithGlobalPermissionsDto
  def read(roleName: String): List[String]
  def read(rolePattern: String,
           page: Int,
           size: Int,
           order: SortOrder,
           field: String
  ): PaginatedResponse[RoleWithGlobalPermissionsDto]
  def readByRolePattern(
    rolePattern: String
  ): List[RoleWithGlobalPermissionsDto]
  def getGlobalPermissionsForRoleId(roleId: String): List[String]
  def getGlobalPermissionsForPrincipal(principalName: String): Set[String]
  def getGlobalPermissionsForRoles(roleNames: List[String]): List[RoleWithGlobalPermissionsDto]
}
