package ai.digital.deploy.permissions.client

import ai.digital.deploy.permissions.api.rest.dto.RoleWithPrincipalsDto
import ai.digital.deploy.permissions.client.util.SortOrder

trait RolePrincipalsServiceClient {
  def addPrincipals(roleName: String, principals: List[String]): RoleWithPrincipalsDto
  def removePrincipals(roleName: String, principals: List[String]): RoleWithPrincipalsDto
  def readPrincipals(roleName: String): List[String]
  def read(rolePattern: String, page: Int, size: Int, order: SortOrder, field: String): PaginatedResponse[RoleWithPrincipalsDto]
  def readByRolePattern(rolePattern: String): List[RoleWithPrincipalsDto]
  def read(principal: String,
           rolePattern: String,
           page: Int,
           size: Int,
           order: SortOrder,
           field: String
  ): PaginatedResponse[RoleWithPrincipalsDto]
  def read(principal: String, rolePattern: String): List[RoleWithPrincipalsDto]
  def read(principals: List[String],
           rolePattern: String,
           page: Int,
           size: Int,
           order: SortOrder,
           field: String
  ): PaginatedResponse[RoleWithPrincipalsDto]
  def read(principals: List[String], rolePattern: String): List[RoleWithPrincipalsDto]
}
