package ai.digital.deploy.permissions.client

import ai.digital.deploy.permissions.api.rest.dto.RoleWithPermissionsDto

import java.util.UUID

trait PermissionServiceClient {
  def createOrUpdate(referenceIdMaybe: Option[UUID],
                     roleName: String,
                     permissionsToAdd: List[String],
                     permissionToDelete: List[String]
  ): Unit

  def checkPermission(referenceMaybe: Option[UUID], permissions: List[String], allRoles: List[String]): Boolean
  def checkPermission(referenceMaybe: Option[UUID],
                      permissions: List[String],
                      allRoles: List[String],
                      principals: List[String]
  ): Boolean
  def checkPermission(references: List[UUID], permissions: List[String], allRoles: List[String]): Map[String, Boolean]
  def checkPermission(references: List[UUID],
                      permissions: List[String],
                      allRoles: List[String],
                      principals: List[String]
  ): Map[String, Boolean]

  @deprecated(
    "This method is never used. In old implementation paging was ignored. Thus leaving this only for compatibility reasons"
  )
  def getAllPermissionsForRole(roleName: String, page: Int, size: Int): RoleWithPermissionsDto
  @deprecated(
    "This method is never used. In old implementation paging was ignored. Thus leaving this only for compatibility reasons - paging is by roles"
  )
  def getAllPermissionsForRoles(roleNames: List[String], page: Int, size: Int): PaginatedResponse[RoleWithPermissionsDto]
  def getAllPermissionsForRole(roleName: String): RoleWithPermissionsDto
  def getAllPermissionsForRoles(roleNames: List[String]): List[RoleWithPermissionsDto]

  def removeForReference(referenceId: UUID): Unit

  def removeAll(): Unit
}
