package ai.digital.deploy.permissions.client.local.logging

import ai.digital.deploy.permissions.api.rest.dto.RoleDto
import ai.digital.deploy.permissions.client.{PaginatedResponse, PrincipalRolesServiceClient}
import ai.digital.deploy.permissions.client.util.SortOrder
import ai.digital.deploy.permissions.config.profile.PermissionServiceProfileConfig.EmbeddedPermissionServiceProfile
import grizzled.slf4j.Logging
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.annotation.Profile
import org.springframework.stereotype.Service

@ConditionalOnProperty(name = Array("xl.permission-service.enabled"), havingValue = "false")
@Service
@Profile(Array(EmbeddedPermissionServiceProfile))
class LoggingPrincipalRolesServiceClient extends PrincipalRolesServiceClient with Logging {
  override def read(principal: String): List[RoleDto] = {
    debug("Called read - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def read(principal: String,
                    namePattern: String,
                    page: Int,
                    size: Int,
                    order: SortOrder,
                    field: String
  ): PaginatedResponse[RoleDto] = {
    debug("Called paginated read - void implementation")
    throw PermissionServiceNotImplementedException()
  }
}
