package ai.digital.deploy.permissions.client.util

import org.springframework.data.domain.Sort

trait SortOrder {
  val value: String
}

object SortOrder {

  case object ASC extends SortOrder {
    override val value: String = "ASC"
  }

  case object DESC extends SortOrder {
    override val value: String = "DESC"
  }

  def getSort(order: SortOrder, property: String): Sort =
    order match {
      case ASC => Sort.by(Sort.Direction.ASC, property)
      case DESC => Sort.by(Sort.Direction.DESC, property)
    }
}
