package ai.digital.deploy.permissions.client.local.logging

import ai.digital.deploy.permissions.api.rest.dto.RoleWithPermissionsDto
import ai.digital.deploy.permissions.client.{PaginatedResponse, PermissionServiceClient}
import ai.digital.deploy.permissions.config.profile.PermissionServiceProfileConfig.EmbeddedPermissionServiceProfile
import grizzled.slf4j.Logging
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.annotation.Profile
import org.springframework.stereotype.Service

import java.util.UUID

@ConditionalOnProperty(name = Array("xl.permission-service.enabled"), havingValue = "false")
@Service
@Profile(Array(EmbeddedPermissionServiceProfile))
class LoggingPermissionsServiceClient extends PermissionServiceClient with Logging {
  private val CHECK_PERMISSION_CALLED = "Called checkPermission - void implementation"

  override def createOrUpdate(referenceIdMaybe: Option[UUID],
                              roleName: String,
                              permissionsToAdd: List[String],
                              permissionToDelete: List[String]
  ): Unit = {
    debug("Called createOrUpdate - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def removeForReference(referenceId: UUID): Unit = {
    debug("Called removeForReference - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def removeAll(): Unit = {
    debug("Called removeAll - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def checkPermission(referenceMaybe: Option[UUID], permissions: List[String], allRoles: List[String]): Boolean = {
    debug(CHECK_PERMISSION_CALLED)
    throw PermissionServiceNotImplementedException()
  }

  override def checkPermission(referenceMaybe: Option[UUID],
                               permissions: List[String],
                               allRoles: List[String],
                               principals: List[String]
  ): Boolean = {
    debug(CHECK_PERMISSION_CALLED)
    throw PermissionServiceNotImplementedException()
  }

  override def checkPermission(references: List[UUID],
                               permissions: List[String],
                               allRoles: List[String]
  ): Map[String, Boolean] = {
    debug(CHECK_PERMISSION_CALLED)
    throw PermissionServiceNotImplementedException()
  }

  override def checkPermission(references: List[UUID],
                               permissions: List[String],
                               allRoles: List[String],
                               principals: List[String]
  ): Map[String, Boolean] = {
    debug(CHECK_PERMISSION_CALLED)
    throw PermissionServiceNotImplementedException()
  }

  override def getAllPermissionsForRole(roleName: String, page: Int, size: Int): RoleWithPermissionsDto = ???

  override def getAllPermissionsForRoles(roleNames: List[String],
                                         page: Int,
                                         size: Int
  ): PaginatedResponse[RoleWithPermissionsDto] = {
    debug("Called paginated getAllPermissionsForRoles - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def getAllPermissionsForRole(roleName: String): RoleWithPermissionsDto = {
    debug("Called getAllPermissionsForRole - void implementation")
    throw PermissionServiceNotImplementedException()
  }

  override def getAllPermissionsForRoles(roleNames: List[String]): List[RoleWithPermissionsDto] = {
    debug("Called getAllPermissionsForRoles - void implementation")
    throw PermissionServiceNotImplementedException()
  }
}
