package ai.digital.deploy.permissions.api.rest.dto

import ai.digital.deploy.permissions.model.{GlobalPermission, ReferencedPermission, Role, RolePrincipal}
import ai.digital.deploy.permissions.rest.dto.validation.IsUuid
import ai.digital.deploy.permissions.model.Role
import org.springframework.data.domain.{Page, PageImpl}

import java.util.UUID
import javax.validation.constraints.{NotBlank, NotNull}
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._

object RoleDto {
  import scala.language.implicitConversions

  implicit def roleToDto(role: Role): RoleDto = RoleDto(role.id, role.name)
  implicit def roleToDto(roles: List[Role]): List[RoleDto] = roles.map(roleToDto)
  implicit def roleToDto(roles: Page[Role]): Page[RoleDto] =
    new PageImpl(
      roles.getContent.asScala.toList.map(roleToDto).asJava,
      roles.getPageable,
      roles.getTotalElements
    )
}

case class RoleDto(id: UUID, name: String)

class CreateRoleRequest {
  @BeanProperty
  @NotBlank(message = "{role.name.not.empty}")
  var name: String = _
}

class UpdateRoleRequest {
  @BeanProperty
  @NotNull(message = "{role.id.not.empty}")
  var id: UUID = _
  @BeanProperty
  @NotBlank(message = "{role.name.not.empty}")
  var name: String = _
}

object RoleFilterDto {
  def apply(namePattern: String): RoleFilterDto = {
    val dto = new RoleFilterDto
    dto.namePattern = namePattern
    dto
  }
}

class RoleFilterDto {
  @BeanProperty
  var namePattern: String = ""
}
object RoleWithPrincipalsDto {
  import scala.language.implicitConversions

  implicit def rolePrincipalToDto(principal: RolePrincipal): String = principal.principalName
  implicit def rolePrincipalToDto(principals: List[RolePrincipal]): List[String] = principals.map(rolePrincipalToDto)
}

case class RoleWithPrincipalsDto(role: RoleDto, principals: List[String])

object RoleWithGlobalPermissionsDto {
  import scala.language.implicitConversions

  implicit def globalPermissionToDto(permission: GlobalPermission): String = permission.permissionName
  implicit def globalPermissionToDto(permissions: List[GlobalPermission]): List[String] = permissions.map(globalPermissionToDto)
}

case class RoleWithGlobalPermissionsDto(role: RoleDto, permissions: List[String])

object RoleWithReferencedPermissionsDto {
  import scala.language.implicitConversions

  implicit def permissionToDto(permission: ReferencedPermission): String = permission.permissionName
  implicit def permissionToDto(permissions: List[ReferencedPermission]): List[String] = permissions.map(permissionToDto)
}

case class RoleWithReferencedPermissionsDto(role: RoleDto, reference: UUID, permissions: List[String])
