package ai.digital.deploy.permissions.api.rest.history.impl

import ai.digital.deploy.permissions.api.rest.dto.{GetRolePrincipalHistoriesForPrincipalNameDto, GetRolePrincipalHistoriesForRoleIdDto, GetRolePrincipalHistoriesForRoleNameDto, GetRolePrincipalHistoriesForRolePrincipalIdDto}
import ai.digital.deploy.permissions.api.rest.history.HistoricalRolePrincipalResource
import ai.digital.deploy.permissions.api.rest.util.PathUtils
import ai.digital.deploy.permissions.model.view.RolePrincipalHistory
import ai.digital.deploy.permissions.service.{RolePrincipalHistoryService, RoleService}
import org.springframework.data.domain.{Page, Pageable}
import org.springframework.web.bind.annotation.{GetMapping, RequestMapping, RestController}

import java.util.UUID
import javax.validation.Valid

object HistoricalRolePrincipalController extends PathUtils {
  final override val BASE_PATH = "/history/principal"
  final val PARAM_PRINCIPAL_NAME = "principalName"
  final val PARAM_ROLE_PRINCIPAL_ID = "rolePrincipalId"
  final val PARAM_ROLE_ID = "roleId"
  final val PARAM_ROLE_NAME = "roleName"
  final val PARAM_START_TIME = "startTime"
  final val PARAM_END_TIME = "endTime"
}

import HistoricalRolePrincipalController._

@RestController
@RequestMapping(Array(BASE_PATH))
class HistoricalRolePrincipalController(rolePrincipalHistoryService: RolePrincipalHistoryService, roleService: RoleService)
    extends HistoricalRolePrincipalResource {
  @GetMapping(params = Array(PARAM_PRINCIPAL_NAME))
  override def getRolePrincipalHistoriesForPrincipalName(@Valid dto: GetRolePrincipalHistoriesForPrincipalNameDto,
                                                         pageable: Pageable
  ): Page[RolePrincipalHistory] =
    rolePrincipalHistoryService.getRolePrincipalHistoriesForPrincipalName(dto.principalName, dto.startTime, dto.endTime, pageable)

  @GetMapping(params = Array(PARAM_ROLE_ID))
  override def getRolePrincipalHistoriesForRoleId(@Valid dto: GetRolePrincipalHistoriesForRoleIdDto,
                                                  pageable: Pageable
  ): Page[RolePrincipalHistory] =
    rolePrincipalHistoryService.getRolePrincipalHistoriesForRoleID(UUID.fromString(dto.roleId),
                                                                   dto.startTime,
                                                                   dto.endTime,
                                                                   pageable
    )

  @GetMapping(params = Array(PARAM_ROLE_NAME))
  override def getRolePrincipalHistoriesForRoleName(
    @Valid dto: GetRolePrincipalHistoriesForRoleNameDto,
    pageable: Pageable
  ): Page[RolePrincipalHistory] = {
    val role = roleService.read(dto.roleName)
    rolePrincipalHistoryService.getRolePrincipalHistoriesForRoleID(role.id, dto.startTime, dto.endTime, pageable)
  }
  @GetMapping(params = Array(PARAM_ROLE_PRINCIPAL_ID))
  override def getRolePrincipalHistoriesForRolePrincipalId(@Valid dto: GetRolePrincipalHistoriesForRolePrincipalIdDto,
                                                           pageable: Pageable
  ): Page[RolePrincipalHistory] =
    rolePrincipalHistoryService.getRolePrincipalHistoriesForRolePrincipalId(UUID.fromString(dto.rolePrincipalId),
                                                                            dto.startTime,
                                                                            dto.endTime,
                                                                            pageable
    )
}
