package ai.digital.deploy.permissions.api.rest.v1

import ai.digital.deploy.permissions.api.rest.dto.{PermissionFilterDto, RoleWithGlobalPermissionsDto}
import ai.digital.deploy.permissions.api.rest.dto.PermissionFilterDto
import org.springframework.data.domain.{Page, Pageable}

trait GlobalPermissionsResource {
  def addPermissions(roleName: String, permissions: List[String]): RoleWithGlobalPermissionsDto

  def removePermissions(roleName: String, permissions: List[String]): RoleWithGlobalPermissionsDto

  def read(roleName: String): List[String]

  def read(permissionFilter: PermissionFilterDto, pageable: Pageable): Page[RoleWithGlobalPermissionsDto]
}
