package ai.digital.deploy.permissions.api.rest.v1

import ai.digital.deploy.permissions.api.rest.dto.{PermissionFilterDto, RoleWithReferencedPermissionsDto}

import java.util.UUID
import ai.digital.deploy.permissions.api.rest.dto.PermissionFilterDto
import org.springframework.data.domain.{Page, Pageable}

trait ReferencedPermissionsResource extends {
  def addPermissions(referenceId: UUID, role: String, permissions: List[String]): RoleWithReferencedPermissionsDto

  def removePermissions(referenceId: UUID, roleName: String, permissions: List[String]): RoleWithReferencedPermissionsDto

  def read(referenceId: UUID, roleName: String): List[String]

  def read(referenceId: UUID, permissionFilter: PermissionFilterDto, pageable: Pageable): Page[RoleWithReferencedPermissionsDto]
}
