package ai.digital.deploy.permissions.api.rest.v1

import ai.digital.deploy.permissions.api.rest.dto.{CreateRoleRequest, RoleDto, RoleFilterDto, UpdateRoleRequest}
import ai.digital.deploy.permissions.api.rest.dto.RoleFilterDto
import org.springframework.data.domain.{Page, Pageable}
import org.springframework.web.bind.annotation.{DeleteMapping, PathVariable}

trait RolesResource {
  def create(createRoleRequest: CreateRoleRequest): RoleDto

  def delete(name: String): Unit

  def deleteAllRoleRefs(name: String): Unit

  def update(updateRoleRequest: UpdateRoleRequest): RoleDto

  def read(name: String): RoleDto

  def read(filter: RoleFilterDto, pageable: Pageable): Page[RoleDto]
}
