package ai.digital.deploy.permissions.api.rest.v1.impl

import ai.digital.deploy.permissions.api.rest.dto.{PermissionFilterDto, RoleWithGlobalPermissionsDto}
import ai.digital.deploy.permissions.api.rest.util.PathUtils
import ai.digital.deploy.permissions.service.{GlobalPermissionService, RoleService}
import ai.digital.deploy.permissions.api.rest.dto.RoleWithGlobalPermissionsDto._
import ai.digital.deploy.permissions.api.rest.v1.GlobalPermissionsResource
import ai.digital.deploy.permissions.api.rest.dto.PermissionFilterDto
import ai.digital.deploy.permissions.service.RoleService
import org.springframework.data.domain.{Page, PageImpl, Pageable}
import org.springframework.web.bind.annotation._

import scala.jdk.CollectionConverters._

object GlobalPermissionsController extends PathUtils {
  final val ROLE_NAME = "/{roleName}"
  final override val BASE_PATH = "/v1/permissions/global"
  final val ADD_PERMISSIONS_PATH = ROLE_NAME
  final val DELETE_PERMISSIONS_PATH = ROLE_NAME
  final val READ_ROLE_PERMISSIONS_PATH = ROLE_NAME
  final val READ_PERMISSIONS_PATH = ""
}

import GlobalPermissionsController._

@RestController
@RequestMapping(Array(BASE_PATH))
class GlobalPermissionsController(globalPermissionService: GlobalPermissionService, roleService: RoleService)
    extends GlobalPermissionsResource {
  @Deprecated
  @PostMapping(Array(ADD_PERMISSIONS_PATH))
  override def addPermissions(@PathVariable roleName: String,
                              @RequestBody permissions: List[String]
  ): RoleWithGlobalPermissionsDto = {
    val (role, globalPermissions) = globalPermissionService.add(roleName, permissions)
    RoleWithGlobalPermissionsDto(role, globalPermissions)
  }

  @Deprecated
  @DeleteMapping(Array(DELETE_PERMISSIONS_PATH))
  override def removePermissions(@PathVariable roleName: String,
                                 @RequestBody permissions: List[String]
  ): RoleWithGlobalPermissionsDto = {
    val (role, globalPermissions) = globalPermissionService.remove(roleName, permissions)
    RoleWithGlobalPermissionsDto(role, globalPermissions)
  }

  @GetMapping(Array(READ_ROLE_PERMISSIONS_PATH))
  override def read(@PathVariable roleName: String): List[String] =
    globalPermissionService.read(roleName)

  @GetMapping
  override def read(permissionFilter: PermissionFilterDto, pageable: Pageable): Page[RoleWithGlobalPermissionsDto] = {
    val roles = roleService.read(permissionFilter.rolePattern, pageable)
    new PageImpl[RoleWithGlobalPermissionsDto](
      roles.getContent.asScala.toList.map { role =>
        RoleWithGlobalPermissionsDto(role, role.globalPermissions.asScala.toList)
      }.asJava,
      pageable,
      roles.getTotalElements
    )
  }
}
