package ai.digital.deploy.permissions.api.rest.v1.impl

import ai.digital.deploy.permissions.api.rest.dto.RoleDto
import ai.digital.deploy.permissions.api.rest.util.PathUtils
import ai.digital.deploy.permissions.api.rest.v1.PrincipalRolesResource
import ai.digital.deploy.permissions.service.PrincipalRoleService
import org.springframework.web.bind.annotation.{GetMapping, PathVariable, RequestMapping, RestController}

object PrincipalRolesController extends PathUtils {
  final override val BASE_PATH = "/v1/principals"
  final val READ_PRINCIPAL_ROLES_PATH = "/{principal}/roles"
}

import PrincipalRolesController._

@RestController
@RequestMapping(Array(BASE_PATH))
class PrincipalRolesController(principalRoleService: PrincipalRoleService) extends PrincipalRolesResource {
  @GetMapping(Array(READ_PRINCIPAL_ROLES_PATH))
  override def read(@PathVariable principal: String): List[RoleDto] =
    principalRoleService.read(principal).map(rp => RoleDto(rp.role.id, rp.role.name))
}
