package ai.digital.deploy.permissions.api.rest.v1.impl

import ai.digital.deploy.permissions.api.rest.dto.{PermissionFilterDto, RoleWithReferencedPermissionsDto}
import ai.digital.deploy.permissions.api.rest.util.PathUtils
import ai.digital.deploy.permissions.service.ReferencedPermissionService

import java.util.UUID
import ai.digital.deploy.permissions.api.rest.dto.RoleWithReferencedPermissionsDto._
import ai.digital.deploy.permissions.api.rest.v1.ReferencedPermissionsResource
import ai.digital.deploy.permissions.api.rest.dto.PermissionFilterDto
import ai.digital.deploy.permissions.service.RoleService
import org.springframework.data.domain.{Page, PageImpl, Pageable}
import org.springframework.web.bind.annotation._

import scala.jdk.CollectionConverters._

object ReferencedPermissionsController extends PathUtils {
  final val REFERENCED_ROLE_ID_PATH = "/{referenceId}/{roleName}"
  final override val BASE_PATH = "/v1/permissions/reference"
  final val ADD_PERMISSIONS_PATH = REFERENCED_ROLE_ID_PATH
  final val REMOVE_PERMISSIONS_PATH = REFERENCED_ROLE_ID_PATH
  final val READ_REFERENCED_ROLE_PERMISSIONS_PATH = REFERENCED_ROLE_ID_PATH
  final val READ_REFERENCED_PERMISSIONS = "/{referenceId}"
}

import ReferencedPermissionsController._

@RestController
@RequestMapping(Array(BASE_PATH))
class ReferencedPermissionsController(referencedPermissionService: ReferencedPermissionService)
    extends ReferencedPermissionsResource {
  @Deprecated
  @PostMapping(Array(ADD_PERMISSIONS_PATH))
  override def addPermissions(@PathVariable referenceId: UUID,
                              @PathVariable roleName: String,
                              @RequestBody permissions: List[String]
  ): RoleWithReferencedPermissionsDto = {
    val (role, rp) = referencedPermissionService.add(referenceId, roleName, permissions)
    RoleWithReferencedPermissionsDto(role, referenceId, rp)
  }

  @Deprecated
  @DeleteMapping(Array(REMOVE_PERMISSIONS_PATH))
  override def removePermissions(@PathVariable referenceId: UUID,
                                 @PathVariable roleName: String,
                                 @RequestBody permissions: List[String]
  ): RoleWithReferencedPermissionsDto = {
    val (role, rp) = referencedPermissionService.remove(referenceId, roleName, permissions)
    RoleWithReferencedPermissionsDto(role, referenceId, rp)
  }

  @GetMapping(Array(READ_REFERENCED_ROLE_PERMISSIONS_PATH))
  override def read(@PathVariable referenceId: UUID, @PathVariable roleName: String): List[String] =
    referencedPermissionService.read(referenceId, roleName).map(_.permissionName)

  @GetMapping(Array(READ_REFERENCED_PERMISSIONS))
  override def read(@PathVariable referenceId: UUID,
                    permissionFilter: PermissionFilterDto,
                    pageable: Pageable
  ): Page[RoleWithReferencedPermissionsDto] = {
    val (rolePage, views) = referencedPermissionService.read(referenceId, permissionFilter.rolePattern, pageable)
    val groupedViews = views.groupBy(_.roleId)
    val dtos = rolePage.getContent.asScala.toList
      .map { role =>
        RoleWithReferencedPermissionsDto(role, referenceId, groupedViews.getOrElse(role.id, List.empty).map(_.permissionName))
      }
    new PageImpl[RoleWithReferencedPermissionsDto](dtos.asJava, pageable, rolePage.getTotalElements)
  }
}
