package ai.digital.deploy.permissions.api.rest.v1.impl

import ai.digital.deploy.permissions.api.rest.util.PathUtils
import ai.digital.deploy.permissions.service.RolePrincipalService
import ai.digital.deploy.permissions.api.rest.dto.RoleDto._
import ai.digital.deploy.permissions.api.rest.dto.RoleWithPrincipalsDto
import ai.digital.deploy.permissions.api.rest.v1.RolePrincipalsResource
import org.springframework.web.bind.annotation._

object RolePrincipalsController extends PathUtils {
  final override val BASE_PATH = "/v1/roles/{roleName}/principals"
  final val ADD_PRINCIPALS_PATH = ""
  final val REMOVE_PRINCIPALS_PATH = ""
  final val READ_PRINCIPALS_PATH = ""
}

import RolePrincipalsController._

@RestController
@RequestMapping(Array(BASE_PATH))
class RolePrincipalsController(rolePrincipalService: RolePrincipalService) extends RolePrincipalsResource {
  @Deprecated
  @PostMapping
  override def addPrincipals(@PathVariable roleName: String, @RequestBody principals: List[String]): RoleWithPrincipalsDto = {
    val (role, rolePrincipals) = rolePrincipalService.add(roleName, principals)
    RoleWithPrincipalsDto(role, rolePrincipals.map(_.principalName))
  }

  @Deprecated
  @DeleteMapping
  override def removePrincipals(@PathVariable roleName: String, @RequestBody principals: List[String]): RoleWithPrincipalsDto = {
    val (role, rolePrincipals) = rolePrincipalService.remove(roleName, principals)
    RoleWithPrincipalsDto(role, rolePrincipals.map(_.principalName))
  }

  @GetMapping
  override def readPrincipals(@PathVariable roleName: String): List[String] =
    rolePrincipalService.read(roleName).map(_.principalName)
}
