package ai.digital.deploy.permissions.api.rest.v1.impl

import ai.digital.deploy.permissions.api.rest.dto.{CreateRoleRequest, RoleDto, RoleFilterDto, UpdateRoleRequest}
import ai.digital.deploy.permissions.api.rest.util.PathUtils
import ai.digital.deploy.permissions.api.rest.v1.RolesResource
import ai.digital.deploy.permissions.model.Role
import ai.digital.deploy.permissions.service.RoleService
import ai.digital.deploy.permissions.api.rest.dto.RoleFilterDto

import javax.validation.Valid
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.ApplicationContext
import org.springframework.data.domain.{Page, Pageable}
import org.springframework.web.bind.annotation._

object RolesController extends PathUtils {
  final override val BASE_PATH = "/v1/roles"
  final val CREATE_ROLE_PATH = ""
  final val DELETE_ROLE = "/{name}"
  final val DELETE_ALL_ROLE_REFS = "/{name}/all"
  final val UPDATE_ROLE = ""
  final val READ_ROLE = "/{name}"
  final val READ_ROLES = ""
}

import RolesController._

@RestController
@RequestMapping(Array(BASE_PATH))
class RolesController(roleService: RoleService) extends RolesResource {
  @Autowired
  var context: ApplicationContext = _

  @PostMapping
  override def create(@Valid @RequestBody createRoleRequest: CreateRoleRequest): RoleDto =
    roleService.create(createRoleRequest.name)

  @DeleteMapping(Array(DELETE_ROLE))
  override def delete(@PathVariable name: String): Unit =
    roleService.delete(name)

  @DeleteMapping(Array(DELETE_ALL_ROLE_REFS))
  override def deleteAllRoleRefs(@PathVariable name: String): Unit =
    roleService.deleteAllRoleReferences(name)

  @PutMapping
  override def update(@Valid @RequestBody updateRoleRequest: UpdateRoleRequest): RoleDto =
    roleService.update(Role(updateRoleRequest.id, updateRoleRequest.name))

  @GetMapping(Array(READ_ROLE))
  override def read(@PathVariable name: String): RoleDto =
    roleService.read(name)

  @GetMapping
  override def read(filter: RoleFilterDto, pageable: Pageable): Page[RoleDto] =
    roleService.read(filter.namePattern, pageable)
}
