package ai.digital.deploy.permissions.api.rest.v2

import ai.digital.deploy.permissions.api.rest.dto.{EditRolePermissionsRequest, GetReferencedPermissionsForPrincipalDto, GetReferencedPermissionsForRoleIdDto, GetReferencedPermissionsForRoleNameDto, RoleWithReferencedPermissionsDto}
import ai.digital.deploy.permissions.api.rest.dto._
import org.springframework.web.bind.annotation.{DeleteMapping, PathVariable}

import java.util.{UUID, Set => JSet}

trait ExtendedReferencedPermissionsResource {
  def editPermissions(referenceId: UUID,
                      roleName: String,
                      editRolePermissionsRequest: EditRolePermissionsRequest
  ): RoleWithReferencedPermissionsDto

  def getReferencesForRole(dto: GetReferencedPermissionsForRoleIdDto): JSet[UUID]

  def getReferencesForRoleName(dto: GetReferencedPermissionsForRoleNameDto): JSet[UUID]

  def getReferencesForPrincipal(dto: GetReferencedPermissionsForPrincipalDto): JSet[UUID]

  def deleteForReference(referenceId: UUID): Unit
}
