package ai.digital.deploy.permissions.api.rest.v2.impl

import ai.digital.deploy.permissions.api.rest.dto.{EditRolePermissionsRequest, GetGlobalPermissionsForPrincipalNameDto, GetGlobalPermissionsForRoleIdDto, RoleWithGlobalPermissionsDto}
import ai.digital.deploy.permissions.api.rest.util.PathUtils
import ai.digital.deploy.permissions.service.GlobalPermissionService
import ai.digital.deploy.permissions.api.rest.dto.RoleWithGlobalPermissionsDto._
import ai.digital.deploy.permissions.api.rest.v2.ExtendedGlobalPermissionsResource
import org.springframework.web.bind.annotation.{GetMapping, PatchMapping, PathVariable, RequestBody, RequestMapping, RestController}

import java.util.UUID
import javax.validation.Valid

object ExtendedGlobalPermissionsController extends PathUtils {
  final override val BASE_PATH = "/v2/permissions/global"
  final val EDIT_ROLE_PERMISSIONS_PATH = "/{roleName}"
  final val GET_PERMISSIONS_PRINCIPAL_NAME = "/principal/{principalName}"
  final val GET_PERMISSIONS_ROLE_ID = "/{roleId}"
}

import ExtendedGlobalPermissionsController._

@RestController
@RequestMapping(Array(BASE_PATH))
class ExtendedGlobalPermissionsController(globalPermissionService: GlobalPermissionService)
    extends ExtendedGlobalPermissionsResource {
  @PatchMapping(Array(EDIT_ROLE_PERMISSIONS_PATH))
  override def editPermissions(
    @PathVariable roleName: String,
    @RequestBody editRolePermissionsRequest: EditRolePermissionsRequest
  ): RoleWithGlobalPermissionsDto = {
    val (role, permissions) = globalPermissionService.edit(
      roleName,
      editRolePermissionsRequest.addedPermissions,
      editRolePermissionsRequest.removedPermissions
    )
    RoleWithGlobalPermissionsDto(role, permissions)
  }

  @GetMapping(Array(GET_PERMISSIONS_ROLE_ID))
  override def getGlobalPermissionsForRoleId(@Valid dto: GetGlobalPermissionsForRoleIdDto): List[String] =
    globalPermissionService.getGlobalPermissionsForRoleId(UUID.fromString(dto.roleId))

  @GetMapping(Array(GET_PERMISSIONS_PRINCIPAL_NAME))
  override def getGlobalPermissionsForPrincipal(@Valid dto: GetGlobalPermissionsForPrincipalNameDto): Set[String] =
    globalPermissionService.getGlobalPermissionsForPrincipal(dto.principalName)
}
