package ai.digital.deploy.permissions.api.rest.v2.impl

import ai.digital.deploy.permissions.api.rest.dto.{EditRolePermissionsRequest, GetReferencedPermissionsForPrincipalDto, GetReferencedPermissionsForRoleIdDto, GetReferencedPermissionsForRoleNameDto, RoleWithReferencedPermissionsDto}
import ai.digital.deploy.permissions.api.rest.util.PathUtils
import ai.digital.deploy.permissions.api.rest.v2.ExtendedReferencedPermissionsResource
import ai.digital.deploy.permissions.service.ReferencedPermissionService
import ai.digital.deploy.permissions.api.rest.dto._
import RoleWithReferencedPermissionsDto._
import org.springframework.web.bind.annotation._

import java.util.{UUID, Set => JSet}
import javax.validation.Valid
import scala.jdk.CollectionConverters._

object ExtendedReferencedPermissionsController extends PathUtils {
  final override val BASE_PATH = "/v2/permissions/reference"
  final val REFERENCE_PERMISSIONS_PATH = "/{referenceId}"
  final val EDIT_PERMISSIONS_PATH = REFERENCE_PERMISSIONS_PATH + "/{roleName}"
  final val GET_REFERENCES = "/refs"

  final val PARAM_ROLE_ID = "roleId"
  final val PARAM_ROLE_NAME = "roleName"
  final val PARAM_PRINCIPAL_NAME = "principalName"
  final val PARAM_PERMISSIONS = "permissions"
}

import ExtendedReferencedPermissionsController._

@RestController
@RequestMapping(Array(BASE_PATH))
class ExtendedReferencedPermissionsController(referencedPermissionService: ReferencedPermissionService)
    extends ExtendedReferencedPermissionsResource {
  @PatchMapping(Array(EDIT_PERMISSIONS_PATH))
  override def editPermissions(
    @PathVariable referenceId: UUID,
    @PathVariable roleName: String,
    @RequestBody editRolePermissionsRequest: EditRolePermissionsRequest
  ): RoleWithReferencedPermissionsDto = {
    val (role, permissions) = referencedPermissionService.edit(
      referenceId,
      roleName,
      editRolePermissionsRequest.addedPermissions,
      editRolePermissionsRequest.removedPermissions
    )
    RoleWithReferencedPermissionsDto(role, referenceId, permissions)
  }

  @GetMapping(value = Array(GET_REFERENCES), params = Array(PARAM_ROLE_ID, PARAM_PERMISSIONS))
  override def getReferencesForRole(@Valid dto: GetReferencedPermissionsForRoleIdDto): JSet[UUID] =
    referencedPermissionService.getReferencesForRole(UUID.fromString(dto.roleId), dto.permissions.asScala.toList).asJava

  @GetMapping(value = Array(GET_REFERENCES), params = Array(PARAM_ROLE_NAME, PARAM_PERMISSIONS))
  override def getReferencesForRoleName(@Valid dto: GetReferencedPermissionsForRoleNameDto): JSet[UUID] =
    referencedPermissionService.getReferencesForRoleName(dto.roleName, dto.permissions.asScala.toList).asJava

  @GetMapping(value = Array(GET_REFERENCES), params = Array(PARAM_PRINCIPAL_NAME, PARAM_PERMISSIONS))
  override def getReferencesForPrincipal(@Valid dto: GetReferencedPermissionsForPrincipalDto): JSet[UUID] =
    referencedPermissionService.getReferencesForPrincipalName(dto.principalName, dto.permissions.asScala.toList).asJava

  @DeleteMapping(value = Array(REFERENCE_PERMISSIONS_PATH))
  override def deleteForReference(@PathVariable referenceId: UUID): Unit =
    referencedPermissionService.removeForReference(referenceId)

}
