package ai.digital.deploy.permissions.api.rest.v2.impl

import ai.digital.deploy.permissions.api.rest.dto.{EditRolePrincipalsRequest, RoleWithPrincipalsDto}
import ai.digital.deploy.permissions.api.rest.util.PathUtils
import ai.digital.deploy.permissions.api.rest.v2.ExtendedRolePrincipalsResource
import ai.digital.deploy.permissions.service.RolePrincipalService
import ai.digital.deploy.permissions.api.rest.dto.RoleWithPrincipalsDto
import RoleWithPrincipalsDto._
import org.springframework.web.bind.annotation.{PatchMapping, PathVariable, RequestBody, RequestMapping, RestController}

object ExtendedRolePrincipalsController extends PathUtils {
  final override val BASE_PATH = "/v2/roles/{roleName}/principals"
  final val EDIT_PRINCIPALS_PATH = ""
}

import ExtendedRolePrincipalsController._

@RestController
@RequestMapping(Array(BASE_PATH))
class ExtendedRolePrincipalsController(rolePrincipalService: RolePrincipalService) extends ExtendedRolePrincipalsResource {
  @PatchMapping
  override def editPrincipals(@PathVariable roleName: String,
                              @RequestBody editRolePrincipalsRequest: EditRolePrincipalsRequest
  ): RoleWithPrincipalsDto = {
    val (role, principals) = rolePrincipalService.edit(
      roleName,
      editRolePrincipalsRequest.addedPrincipals,
      editRolePrincipalsRequest.removedPrincipals
    )
    RoleWithPrincipalsDto(role, principals)
  }
}
