/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.api.rest;

import ai.digital.deploy.permissions.MessageHandler;
import ai.digital.deploy.permissions.api.error.BaseError;
import ai.digital.deploy.permissions.api.error.FieldErrorDto$;
import ai.digital.deploy.permissions.api.error.PaginationParseError;
import ai.digital.deploy.permissions.api.error.ResourceNotFoundError;
import ai.digital.deploy.permissions.api.error.ValidationError;
import ai.digital.deploy.permissions.exception.PaginationParseException;
import ai.digital.deploy.permissions.exception.ResourceNotFoundException;
import ai.digital.deploy.permissions.exception.RoleNotFoundException;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@RestControllerAdvice
@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001B\u0004\t\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\u0006C\u0001!\tA\t\u0005\bM\u0001\u0011\r\u0011\"\u0003(\u0011\u0019\u0019\u0004\u0001)A\u0005Q!)A\u0007\u0001C\u0001k!)1\u000e\u0001C\u0001Y\n9RI\u001d:pe\"\u000bg\u000e\u001a7j]\u001e\u001cuN\u001c;s_2dWM\u001d\u0006\u0003\u0013)\tAA]3ti*\u00111\u0002D\u0001\u0004CBL'BA\u0007\u000f\u0003-\u0001XM]7jgNLwN\\:\u000b\u0005=\u0001\u0012A\u00023fa2|\u0017P\u0003\u0002\u0012%\u00059A-[4ji\u0006d'\"A\n\u0002\u0005\u0005L7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0017AD7fgN\fw-\u001a%b]\u0012dWM\u001d\t\u0003=}i\u0011\u0001D\u0005\u0003A1\u0011a\"T3tg\u0006<W\rS1oI2,'/\u0001\u0004=S:LGO\u0010\u000b\u0003G\u0015\u0002\"\u0001\n\u0001\u000e\u0003!AQ\u0001\b\u0002A\u0002u\tqB^1mS\u0012\fG/[8o\u000bJ\u0014xN]\u000b\u0002QA\u0011\u0011\u0006\r\b\u0003U9\u0002\"a\u000b\r\u000e\u00031R!!\f\u000b\u0002\rq\u0012xn\u001c;?\u0013\ty\u0003$\u0001\u0004Qe\u0016$WMZ\u0005\u0003cI\u0012aa\u0015;sS:<'BA\u0018\u0019\u0003A1\u0018\r\\5eCRLwN\\#se>\u0014\b%A\u000biC:$G.\u001a,bY&$\u0017\r^5p]\u0016\u0013(o\u001c:\u0015\u0005Y1\u0004\"B\u001c\u0006\u0001\u0004A\u0014AA3y!\tIdH\u0004\u0002;y9\u00111fO\u0005\u00023%\u0011Q\bG\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0004IA\u0005Fq\u000e,\u0007\u000f^5p]*\u0011Q\b\u0007\u0015\u0005\u000b\t\u0003\u0016\u000b\u0005\u0002D\u001d6\tAI\u0003\u0002F\r\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u001dC\u0015\u0001\u00022j]\u0012T!!\u0013&\u0002\u0007],'M\u0003\u0002L\u0019\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001N\u0003\ry'oZ\u0005\u0003\u001f\u0012\u0013\u0001#\u0012=dKB$\u0018n\u001c8IC:$G.\u001a:\u0002\u000bY\fG.^3-\u0005IK6%A*\u0011\u0005Q;V\"A+\u000b\u0005YS\u0015A\u0003<bY&$\u0017\r^5p]&\u0011\u0001,\u0016\u0002\u000e\u0005&tG-\u0012=dKB$\u0018n\u001c8$\u0003i\u0003\"a\u00170\u000e\u0003qS!!\u0018\u0007\u0002\u0013\u0015D8-\u001a9uS>t\u0017BA0]\u0005a\u0001\u0016mZ5oCRLwN\u001c)beN,W\t_2faRLwN\u001c\u0015\u0005\u000b\u0005\u0004F\r\u0005\u0002DE&\u00111\r\u0012\u0002\u000f%\u0016\u001c\bo\u001c8tKN#\u0018\r^;tI\u0005)\u0017B\u00014h\u0003-\u0011\u0015\tR0S\u000bF+Vi\u0015+\u000b\u0005!L\u0017A\u0003%uiB\u001cF/\u0019;vg*\u0011!NS\u0001\u0005QR$\b/\u0001\biC:$G.\u001a(pi\u001a{WO\u001c3\u0015\u00055\u001c\bC\u00018r\u001b\u0005y'B\u00019\u000b\u0003\u0015)'O]8s\u0013\t\u0011xNA\u000bSKN|WO]2f\u001d>$hi\\;oI\u0016\u0013(o\u001c:\t\u000b]2\u0001\u0019\u0001;\u0011\u0005m+\u0018B\u0001<]\u0005e\u0011Vm]8ve\u000e,gj\u001c;G_VtG-\u0012=dKB$\u0018n\u001c8)\t\u0019\u0011\u0005\u000b\u001f\u0017\u0003sj\u001c\u0013\u0001^\u0012\u0002wB\u00111\f`\u0005\u0003{r\u0013QCU8mK:{GOR8v]\u0012,\u0005pY3qi&|g\u000e\u000b\u0003\u0007CB{HEAA\u0001\u0013\r\t\u0019aZ\u0001\n\u001d>#vLR(V\u001d\u0012C3\u0001AA\u0004!\r\u0019\u0015\u0011B\u0005\u0004\u0003\u0017!%\u0001\u0006*fgR\u001cuN\u001c;s_2dWM]!em&\u001cW\r")
public class ErrorHandlingController {
    private final MessageHandler messageHandler;
    private final String validationError;

    private String validationError() {
        return this.validationError;
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BindException.class, PaginationParseException.class})
    public Object handleValidationError(Exception ex) {
        BaseError baseError;
        Exception exception = ex;
        if (exception instanceof BindException) {
            BindException bindException = (BindException)exception;
            baseError = new ValidationError(this.messageHandler.getMessage(this.validationError(), (Seq<Object>)Nil$.MODULE$), FieldErrorDto$.MODULE$.toFieldErrorDto((List<FieldError>)CollectionConverters$.MODULE$.ListHasAsScala(bindException.getBindingResult().getFieldErrors()).asScala().toList()));
        } else if (exception instanceof PaginationParseException) {
            PaginationParseException paginationParseException = (PaginationParseException)exception;
            baseError = new PaginationParseError(paginationParseException.getMessage());
        } else {
            throw new MatchError((Object)exception);
        }
        return baseError;
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={ResourceNotFoundException.class, RoleNotFoundException.class})
    public ResourceNotFoundError handleNotFound(ResourceNotFoundException ex) {
        ResourceNotFoundError resourceNotFoundError;
        ResourceNotFoundException resourceNotFoundException = ex;
        if (resourceNotFoundException instanceof RoleNotFoundException) {
            RoleNotFoundException roleNotFoundException = (RoleNotFoundException)resourceNotFoundException;
            resourceNotFoundError = new ResourceNotFoundError(this.messageHandler.getMessage("role.not.found", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{roleNotFoundException.name()})));
        } else if (resourceNotFoundException != null) {
            ResourceNotFoundException resourceNotFoundException2 = resourceNotFoundException;
            resourceNotFoundError = new ResourceNotFoundError(resourceNotFoundException2.message());
        } else {
            throw new MatchError((Object)resourceNotFoundException);
        }
        return resourceNotFoundError;
    }

    public ErrorHandlingController(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.validationError = "error.validation";
    }
}

