package ai.digital.deploy.permissions.api.rest.history.impl

import ai.digital.deploy.permissions.api.rest.dto.{GetGlobalPermissionHistoriesForGlobalPermissionIdDto, GetGlobalPermissionHistoriesForPermissionDto, GetGlobalPermissionHistoriesForRoleIdDto, GetGlobalPermissionHistoriesForRoleNameDto}
import ai.digital.deploy.permissions.api.rest.history.HistoricalGlobalPermissionResource
import ai.digital.deploy.permissions.api.rest.util.PathUtils
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException
import ai.digital.deploy.permissions.model.view.GlobalPermissionHistory
import ai.digital.deploy.permissions.service.{GlobalPermissionHistoryService, RoleService}
import org.springframework.data.domain.{Page, Pageable}
import org.springframework.web.bind.annotation.{GetMapping, RequestMapping, RestController}

import java.util.UUID
import javax.validation.Valid

object HistoricalGlobalPermissionController extends PathUtils {
  final override val BASE_PATH = "/history/permissions/global"
  final val PARAM_GLOBAL_PERMISSION_ID = "globalPermissionId"
  final val PARAM_PERMISSION_NAME = "permissionName"
  final val PARAM_ROLE_ID = "roleId"
  final val PARAM_ROLE_NAME = "roleName"
  final val PARAM_START_TIME = "startTime"
  final val PARAM_END_TIME = "endTime"
}

import ai.digital.deploy.permissions.api.rest.history.impl.HistoricalGlobalPermissionController._

@RestController
@RequestMapping(Array(BASE_PATH))
class HistoricalGlobalPermissionController(globalPermissionHistoryService: GlobalPermissionHistoryService,
                                           roleService: RoleService
) extends HistoricalGlobalPermissionResource {
  @GetMapping(params = Array(PARAM_GLOBAL_PERMISSION_ID))
  override def getGlobalPermissionHistoriesForGlobalPermissionId(@Valid dto: GetGlobalPermissionHistoriesForGlobalPermissionIdDto,
                                                                 pageable: Pageable
  ): Page[GlobalPermissionHistory] =
    globalPermissionHistoryService.getGlobalPermissionHistoriesForGlobalPermissionId(UUID.fromString(dto.globalPermissionId),
                                                                                     dto.startTime,
                                                                                     dto.endTime,
                                                                                     pageable
    )

  @GetMapping(params = Array(PARAM_PERMISSION_NAME))
  override def getGlobalPermissionHistoriesForPermissionName(@Valid dto: GetGlobalPermissionHistoriesForPermissionDto,
                                                             pageable: Pageable
  ): Page[GlobalPermissionHistory] =
    globalPermissionHistoryService.getGlobalPermissionHistoriesForPermissionName(dto.permissionName,
                                                                                 dto.startTime,
                                                                                 dto.endTime,
                                                                                 pageable
    )

  @GetMapping(params = Array(PARAM_ROLE_ID))
  override def getGlobalPermissionHistoriesForRoleId(@Valid dto: GetGlobalPermissionHistoriesForRoleIdDto,
                                                     pageable: Pageable
  ): Page[GlobalPermissionHistory] =
    globalPermissionHistoryService.getGlobalPermissionHistoriesForRoleId(UUID.fromString(dto.roleId),
                                                                         dto.startTime,
                                                                         dto.endTime,
                                                                         pageable
    )

  @GetMapping(params = Array(PARAM_ROLE_NAME))
  override def getGlobalPermissionHistoriesForRoleName(@Valid dto: GetGlobalPermissionHistoriesForRoleNameDto,
                                                       pageable: Pageable
  ): Page[GlobalPermissionHistory] = {
    val role = roleService
      .read(dto.roleName).getOrElse(throw RoleNameNotFoundException(dto.roleName))
    globalPermissionHistoryService.getGlobalPermissionHistoriesForRoleId(role.id, dto.startTime, dto.endTime, pageable)
  }
}
