package ai.digital.deploy.permissions.api.rest.history

import ai.digital.deploy.permissions.api.rest.dto.{GetGlobalPermissionHistoriesForGlobalPermissionIdDto, GetGlobalPermissionHistoriesForPermissionDto, GetGlobalPermissionHistoriesForRoleIdDto, GetGlobalPermissionHistoriesForRoleNameDto}
import ai.digital.deploy.permissions.model.view.GlobalPermissionHistory
import org.springframework.data.domain.{Page, Pageable}

trait HistoricalGlobalPermissionResource {
  def getGlobalPermissionHistoriesForGlobalPermissionId(dto: GetGlobalPermissionHistoriesForGlobalPermissionIdDto,
                                                        pageable: Pageable
  ): Page[GlobalPermissionHistory]
  def getGlobalPermissionHistoriesForPermissionName(dto: GetGlobalPermissionHistoriesForPermissionDto,
                                                    pageable: Pageable
  ): Page[GlobalPermissionHistory]
  def getGlobalPermissionHistoriesForRoleId(dto: GetGlobalPermissionHistoriesForRoleIdDto,
                                            pageable: Pageable
  ): Page[GlobalPermissionHistory]
  def getGlobalPermissionHistoriesForRoleName(dto: GetGlobalPermissionHistoriesForRoleNameDto,
                                              pageable: Pageable
  ): Page[GlobalPermissionHistory]
}
