package ai.digital.deploy.permissions.api.rest.v1.impl

import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter._
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithGlobalPermissionsConverter._
import ai.digital.deploy.permissions.api.rest.dto.{PermissionFilterDto, RoleWithGlobalPermissionsDto}
import ai.digital.deploy.permissions.api.rest.v1.GlobalPermissionsPaths._
import ai.digital.deploy.permissions.rest.dto.validation.NonEmptyElements
import ai.digital.deploy.permissions.service.{GlobalPermissionService, RoleService}
import org.hibernate.validator.constraints.UniqueElements
import org.springframework.data.domain.{Page, PageImpl, Pageable}
import org.springframework.validation.annotation.Validated
import org.springframework.web.bind.annotation._

import java.util.{List => JList}
import scala.jdk.CollectionConverters._

@Validated
@RestController
@RequestMapping(Array(BASE_PATH))
class GlobalPermissionsController(globalPermissionService: GlobalPermissionService, roleService: RoleService) {
  @Deprecated
  @PostMapping(Array(ADD_PERMISSIONS_PATH))
  def addPermissions(@PathVariable roleName: String,
                     @UniqueElements(message = "{permission.added.list.duplicate}")
                     @NonEmptyElements(message = "{permission.listValues.not.empty}")
                     @RequestBody permissions: JList[String]
  ): RoleWithGlobalPermissionsDto = {
    val (role, globalPermissions) = globalPermissionService.add(roleName, permissions.asScala.toList)
    RoleWithGlobalPermissionsDto(role, globalPermissions)
  }

  @Deprecated
  @DeleteMapping(Array(DELETE_PERMISSIONS_PATH))
  def removePermissions(@PathVariable roleName: String,
                        @UniqueElements(message = "{permission.added.list.duplicate}")
                        @NonEmptyElements(message = "{permission.listValues.not.empty}")
                        @RequestBody permissions: JList[String]
  ): RoleWithGlobalPermissionsDto = {
    val (role, globalPermissions) = globalPermissionService.remove(roleName, permissions.asScala.toList)
    RoleWithGlobalPermissionsDto(role, globalPermissions)
  }

  @GetMapping(Array(READ_ROLE_PERMISSIONS_PATH))
  def read(@PathVariable roleName: String): List[String] =
    globalPermissionService.read(roleName)

  @GetMapping
  def read(permissionFilter: PermissionFilterDto, pageable: Pageable): Page[RoleWithGlobalPermissionsDto] = {
    val roles = roleService.read(permissionFilter.rolePattern, pageable)
    new PageImpl[RoleWithGlobalPermissionsDto](
      roles.getContent.asScala.toList.map { role =>
        RoleWithGlobalPermissionsDto(role, role.globalPermissions.asScala.toList)
      }.asJava,
      pageable,
      roles.getTotalElements
    )
  }

  @GetMapping(Array(READ_PERMISSIONS_WITH_FILTER_PATH))
  def readByRolePattern(permissionFilter: PermissionFilterDto): List[RoleWithGlobalPermissionsDto] =
    Option(permissionFilter.rolePattern)
      .map(rp =>
        globalPermissionService
          .readByRolePattern(rp)
      ).getOrElse(globalPermissionService.read()).groupBy(_.role).map {
        case (role, permissions) =>
          RoleWithGlobalPermissionsDto(role, permissions.map(_.permissionName))
      }.toList

  @GetMapping(Array(READ_PERMISSIONS_FOR_ROLES))
  def readForRoles(@RequestBody roleIds: List[String]): List[RoleWithGlobalPermissionsDto] =
    globalPermissionService
      .read(roleIds).groupBy(_.role).map {
        case (role, permissions) =>
          RoleWithGlobalPermissionsDto(role, permissions.map(_.permissionName))
      }.toList
}
