package ai.digital.deploy.permissions.api.rest.v2.impl

import ai.digital.deploy.permissions.api.rest.dto._
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter._
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithReferencedPermissionsConverter._
import ai.digital.deploy.permissions.api.rest.v2.ExtendedReferencedPermissionsPaths._
import ai.digital.deploy.permissions.rest.dto.validation.IsUuid
import ai.digital.deploy.permissions.service.ReferencedPermissionService
import org.springframework.validation.annotation.Validated
import org.springframework.web.bind.annotation._

import java.util.{UUID, Set => JSet}
import javax.validation.Valid
import scala.jdk.CollectionConverters._

@Validated
@RestController
@RequestMapping(Array(BASE_PATH))
class ExtendedReferencedPermissionsController(referencedPermissionService: ReferencedPermissionService) {
  @PatchMapping(Array(EDIT_PERMISSIONS_PATH))
  def editPermissions(
    @IsUuid @PathVariable referenceId: String,
    @PathVariable roleName: String,
    @Valid
    @RequestBody editRolePermissionsRequest: EditRolePermissionsRequest
  ): RoleWithReferencedPermissionsDto = {
    val uuid = UUID.fromString(referenceId)
    val (role, permissions) = referencedPermissionService.edit(
      uuid,
      roleName,
      editRolePermissionsRequest.addedPermissions.asScala.toList,
      editRolePermissionsRequest.removedPermissions.asScala.toList
    )
    RoleWithReferencedPermissionsDto(role, uuid, permissions)
  }

  @GetMapping(value = Array(GET_REFERENCES), params = Array(PARAM_ROLE_ID, PARAM_PERMISSIONS))
  def getReferencesForRole(@Valid dto: GetReferencedPermissionsForRoleIdDto): JSet[UUID] =
    referencedPermissionService.getReferencesForRole(UUID.fromString(dto.roleId), dto.permissions.asScala.toList).asJava

  @GetMapping(value = Array(GET_REFERENCES), params = Array(PARAM_ROLE_NAME, PARAM_PERMISSIONS))
  def getReferencesForRoleName(@Valid dto: GetReferencedPermissionsForRoleNameDto): JSet[UUID] =
    referencedPermissionService.getReferencesForRoleName(dto.roleName, dto.permissions.asScala.toList).asJava

  @GetMapping(value = Array(GET_REFERENCES), params = Array(PARAM_PRINCIPAL_NAME, PARAM_PERMISSIONS))
  def getReferencesForPrincipal(@Valid dto: GetReferencedPermissionsForPrincipalDto): JSet[UUID] =
    referencedPermissionService.getReferencesForPrincipalName(dto.principalName, dto.permissions.asScala.toList).asJava

  @DeleteMapping(value = Array(REFERENCE_PERMISSIONS_PATH))
  def deleteForReference(@IsUuid @PathVariable referenceId: String): Unit =
    referencedPermissionService.removeForReference(UUID.fromString(referenceId))

  @DeleteMapping(value = Array(DELETE_ALL_PATH))
  def deleteAll(): Unit =
    referencedPermissionService.removeAll()

}
