package ai.digital.deploy.permissions.api.rest.history

import ai.digital.deploy.permissions.api.rest.dto._
import ai.digital.deploy.permissions.model.view.ReferencedPermissionHistory
import org.springframework.data.domain.{Page, Pageable}

import java.util.{UUID, List => JList}

trait HistoricalReferencedPermissionResource {
  def listReferencesByRoleAndPermissions(request: GetReferencedPermissionTimeRangeByRole): JList[ReferencedPermissionTimeRangeDto]

  def listReferencesByPrincipalAndPermissions(
    request: GetReferencedPermissionTimeRangeByPrincipal
  ): JList[ReferencedPermissionTimeRangeDto]

  def listReferencesByRoleAndReferenceAndPermissions(
    request: GetReferencedPermissionTimeRangeByRoleAndRef
  ): JList[ReferencedPermissionTimeRangeDto]

  def listReferencesByPrincipalAndReferenceAndPermissions(
    request: GetReferencedPermissionTimeRangeByPrincipalAndRef
  ): JList[ReferencedPermissionTimeRangeDto]

  def getReferenceHistoriesForReferenceAndPermission(dto: GetReferenceHistoriesByPermissionName,
                                                     pageable: Pageable
  ): Page[ReferencedPermissionHistory]
  def getReferenceHistoriesForReferenceAndReferencedPermissionId(dto: GetReferenceHistoriesByReferencedPermissionId,
                                                                 pageable: Pageable
  ): Page[ReferencedPermissionHistory]
  def getReferenceHistoriesForRoleId(dto: GetReferenceHistoriesByRoleId, pageable: Pageable): Page[ReferencedPermissionHistory]
  def getReferenceHistoriesForRoleName(dto: GetReferenceHistoriesRoleName, pageable: Pageable): Page[ReferencedPermissionHistory]
  def getReferenceHistoriesForReferenceAndRoleId(dto: GetReferenceHistoriesByRoleIdTimeRange,
                                                 pageable: Pageable
  ): Page[ReferencedPermissionHistory]
}
