/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.api.rest;

import ai.digital.deploy.permissions.MessageHandler;
import ai.digital.deploy.permissions.api.error.BaseError;
import ai.digital.deploy.permissions.api.error.FieldErrorDto$;
import ai.digital.deploy.permissions.api.error.PaginationParseError;
import ai.digital.deploy.permissions.api.error.ResourceAlreadyExistsError;
import ai.digital.deploy.permissions.api.error.ResourceNotFoundError;
import ai.digital.deploy.permissions.api.error.ValidationError;
import ai.digital.deploy.permissions.exception.PaginationParseException;
import ai.digital.deploy.permissions.exception.ResourceAlreadyExistsException;
import ai.digital.deploy.permissions.exception.ResourceNotFoundException;
import ai.digital.deploy.permissions.exception.RoleIdNotFoundException;
import ai.digital.deploy.permissions.exception.RoleNameAlreadyExistsException;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@RestControllerAdvice
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001\u0002\u0005\n\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\u0006E\u0001!\ta\t\u0005\bO\u0001\u0011\r\u0011\"\u0003)\u0011\u0019!\u0004\u0001)A\u0005S!)Q\u0007\u0001C\u0001m!)A\u000e\u0001C\u0001[\"1q\u0010\u0001C\u0001\u0003\u0003\u0011q#\u0012:s_JD\u0015M\u001c3mS:<7i\u001c8ue>dG.\u001a:\u000b\u0005)Y\u0011\u0001\u0002:fgRT!\u0001D\u0007\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u000f\u001f\u0005Y\u0001/\u001a:nSN\u001c\u0018n\u001c8t\u0015\t\u0001\u0012#\u0001\u0004eKBdw.\u001f\u0006\u0003%M\tq\u0001Z5hSR\fGNC\u0001\u0015\u0003\t\t\u0017n\u0001\u0001\u0014\u0005\u00019\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g-\u0001\bnKN\u001c\u0018mZ3IC:$G.\u001a:\u0011\u0005}\u0001S\"A\u0007\n\u0005\u0005j!AD'fgN\fw-\u001a%b]\u0012dWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u00112\u0003CA\u0013\u0001\u001b\u0005I\u0001\"B\u000f\u0003\u0001\u0004q\u0012a\u0004<bY&$\u0017\r^5p]\u0016\u0013(o\u001c:\u0016\u0003%\u0002\"AK\u0019\u000f\u0005-z\u0003C\u0001\u0017\u001a\u001b\u0005i#B\u0001\u0018\u0016\u0003\u0019a$o\\8u}%\u0011\u0001'G\u0001\u0007!J,G-\u001a4\n\u0005I\u001a$AB*ue&twM\u0003\u000213\u0005\u0001b/\u00197jI\u0006$\u0018n\u001c8FeJ|'\u000fI\u0001\u0016Q\u0006tG\r\\3WC2LG-\u0019;j_:,%O]8s)\t9r\u0007C\u00039\u000b\u0001\u0007\u0011(\u0001\u0002fqB\u0011!h\u0010\b\u0003wur!\u0001\f\u001f\n\u0003iI!AP\r\u0002\u000fA\f7m[1hK&\u0011\u0001)\u0011\u0002\n\u000bb\u001cW\r\u001d;j_:T!AP\r)\t\u0015\u0019\u0015K\u0015\t\u0003\t>k\u0011!\u0012\u0006\u0003\r\u001e\u000b!\"\u00198o_R\fG/[8o\u0015\tA\u0015*\u0001\u0003cS:$'B\u0001&L\u0003\r9XM\u0019\u0006\u0003\u00196\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u001d\u0006\u0019qN]4\n\u0005A+%\u0001E#yG\u0016\u0004H/[8o\u0011\u0006tG\r\\3s\u0003\u00151\u0018\r\\;fY\t\u0019&lI\u0001U!\t)\u0006,D\u0001W\u0015\t96*\u0001\u0006wC2LG-\u0019;j_:L!!\u0017,\u0003\u001b\tKg\u000eZ#yG\u0016\u0004H/[8oG\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u00010\u000e\u0003%)\u0007pY3qi&|g.\u0003\u0002a;\nA\u0002+Y4j]\u0006$\u0018n\u001c8QCJ\u001cX-\u0012=dKB$\u0018n\u001c8)\t\u0015\u0011\u0017+\u001a\t\u0003\t\u000eL!\u0001Z#\u0003\u001dI+7\u000f]8og\u0016\u001cF/\u0019;vg\u0012\na-\u0003\u0002hQ\u0006Y!)\u0011#`%\u0016\u000bV+R*U\u0015\tI'.\u0001\u0006IiR\u00048\u000b^1ukNT!a[&\u0002\t!$H\u000f]\u0001\u000fQ\u0006tG\r\\3O_R4u.\u001e8e)\tqG\u000f\u0005\u0002pe6\t\u0001O\u0003\u0002r\u0017\u0005)QM\u001d:pe&\u00111\u000f\u001d\u0002\u0016%\u0016\u001cx.\u001e:dK:{GOR8v]\u0012,%O]8s\u0011\u0015Ad\u00011\u0001v!\taf/\u0003\u0002x;\nI\"+Z:pkJ\u001cWMT8u\r>,h\u000eZ#yG\u0016\u0004H/[8oQ\u001111)U=-\u0003i\u001c\u0013!\u001e\u0015\u0005\r\t\fF\u0010J\u0001~\u0013\tq\b.A\u0005O\u001fR{fiT+O\t\u0006\u0019\u0002.\u00198eY\u0016\fEN]3bIf,\u00050[:ugR!\u00111AA\u0005!\ry\u0017QA\u0005\u0004\u0003\u000f\u0001(A\u0007*fg>,(oY3BYJ,\u0017\rZ=Fq&\u001cHo]#se>\u0014\bB\u0002\u001d\b\u0001\u0004\tY\u0001E\u0002]\u0003\u001bI1!a\u0004^\u0005y\u0011Vm]8ve\u000e,\u0017\t\u001c:fC\u0012LX\t_5tiN,\u0005pY3qi&|g\u000eK\u0003\b\u0007F\u000b\u0019\u0002\f\u0002\u0002\u0016\r\u0012\u00111\u0002\u0015\u0005\u000f\t\fV\rK\u0002\u0001\u00037\u00012\u0001RA\u000f\u0013\r\ty\"\u0012\u0002\u0015%\u0016\u001cHoQ8oiJ|G\u000e\\3s\u0003\u00124\u0018nY3")
public class ErrorHandlingController {
    private final MessageHandler messageHandler;
    private final String validationError;

    private String validationError() {
        return this.validationError;
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BindException.class, PaginationParseException.class})
    public Object handleValidationError(Exception ex) {
        BaseError baseError;
        Exception exception = ex;
        if (exception instanceof BindException) {
            BindException bindException = (BindException)exception;
            baseError = new ValidationError(this.messageHandler.getMessage(this.validationError(), (Seq<Object>)Nil$.MODULE$), FieldErrorDto$.MODULE$.toFieldErrorDto((List<FieldError>)CollectionConverters$.MODULE$.ListHasAsScala(bindException.getBindingResult().getFieldErrors()).asScala().toList()));
        } else if (exception instanceof PaginationParseException) {
            PaginationParseException paginationParseException = (PaginationParseException)exception;
            baseError = new PaginationParseError(paginationParseException.getMessage());
        } else {
            throw new MatchError((Object)exception);
        }
        return baseError;
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={ResourceNotFoundException.class})
    public ResourceNotFoundError handleNotFound(ResourceNotFoundException ex) {
        ResourceNotFoundError resourceNotFoundError;
        ResourceNotFoundException resourceNotFoundException = ex;
        if (resourceNotFoundException instanceof RoleNameNotFoundException) {
            RoleNameNotFoundException roleNameNotFoundException = (RoleNameNotFoundException)resourceNotFoundException;
            resourceNotFoundError = new ResourceNotFoundError(this.messageHandler.getMessage("role.name.not.found", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{roleNameNotFoundException.name()})));
        } else if (resourceNotFoundException instanceof RoleIdNotFoundException) {
            RoleIdNotFoundException roleIdNotFoundException = (RoleIdNotFoundException)resourceNotFoundException;
            resourceNotFoundError = new ResourceNotFoundError(this.messageHandler.getMessage("role.id.not.found", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{roleIdNotFoundException.id()})));
        } else if (resourceNotFoundException != null) {
            ResourceNotFoundException resourceNotFoundException2 = resourceNotFoundException;
            resourceNotFoundError = new ResourceNotFoundError(resourceNotFoundException2.message());
        } else {
            throw new MatchError((Object)resourceNotFoundException);
        }
        return resourceNotFoundError;
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ResourceAlreadyExistsException.class})
    public ResourceAlreadyExistsError handleAlreadyExists(ResourceAlreadyExistsException ex) {
        ResourceAlreadyExistsError resourceAlreadyExistsError;
        ResourceAlreadyExistsException resourceAlreadyExistsException = ex;
        if (resourceAlreadyExistsException instanceof RoleNameAlreadyExistsException) {
            RoleNameAlreadyExistsException roleNameAlreadyExistsException = (RoleNameAlreadyExistsException)resourceAlreadyExistsException;
            resourceAlreadyExistsError = new ResourceAlreadyExistsError(this.messageHandler.getMessage("role.name.already.exists", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{roleNameAlreadyExistsException.name()})));
        } else if (resourceAlreadyExistsException != null) {
            ResourceAlreadyExistsException resourceAlreadyExistsException2 = resourceAlreadyExistsException;
            resourceAlreadyExistsError = new ResourceAlreadyExistsError(resourceAlreadyExistsException2.message());
        } else {
            throw new MatchError((Object)resourceAlreadyExistsException);
        }
        return resourceAlreadyExistsError;
    }

    public ErrorHandlingController(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.validationError = "error.validation";
    }
}

