/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.api.rest.v1.impl;

import ai.digital.deploy.permissions.api.rest.dto.CreateRoleRequest;
import ai.digital.deploy.permissions.api.rest.dto.RoleDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleFilterDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleIdRequest;
import ai.digital.deploy.permissions.api.rest.dto.UpdateRoleRequest;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.api.rest.v1.RolesResource;
import ai.digital.deploy.permissions.exception.RoleIdNotFoundException;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.model.Role$;
import ai.digital.deploy.permissions.service.RoleService;
import java.io.Serializable;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import scala.Function0;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@RestController
@RequestMapping(value={"/v1/roles"})
@ScalaSignature(bytes="\u0006\u0005\t\u001dc\u0001\u0002\u000b\u0016\u0001\u0019B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\u0006q\u0001!\t!\u000f\u0005\n{\u0001\u0001\r\u00111A\u0005\u0002yB\u0011\u0002\u0013\u0001A\u0002\u0003\u0007I\u0011A%\t\u0013=\u0003\u0001\u0019!A!B\u0013y\u0004\"B.\u0001\t\u0003b\u0006\"B?\u0001\t\u0003r\bbBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u001d\t\u0019\b\u0001C!\u0003kBq!a#\u0001\t\u0003\ni\tC\u0004\u0002\u001c\u0002!\t%!(\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\"9\u0011Q\u0017\u0001\u0005B\u0005]\u0006bBA[\u0001\u0011\u0005\u0013\u0011\u0019\u0005\b\u0003S\u0004A\u0011IAv\u0011\u001d\t)\u0010\u0001C!\u0003oDqAa\u0003\u0001\t\u0003\u0012i\u0001C\u0004\u0003$\u0001!\tE!\n\u0003\u001fI{G.Z:D_:$(o\u001c7mKJT!AF\f\u0002\t%l\u0007\u000f\u001c\u0006\u00031e\t!A^\u0019\u000b\u0005iY\u0012\u0001\u0002:fgRT!\u0001H\u000f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u001f?\u0005Y\u0001/\u001a:nSN\u001c\u0018n\u001c8t\u0015\t\u0001\u0013%\u0001\u0004eKBdw.\u001f\u0006\u0003E\r\nq\u0001Z5hSR\fGNC\u0001%\u0003\t\t\u0017n\u0001\u0001\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]=j\u0011aF\u0005\u0003a]\u0011QBU8mKN\u0014Vm]8ve\u000e,\u0017a\u0003:pY\u0016\u001cVM\u001d<jG\u0016\u0004\"a\r\u001c\u000e\u0003QR!!N\u000f\u0002\u000fM,'O^5dK&\u0011q\u0007\u000e\u0002\f%>dWmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003uq\u0002\"a\u000f\u0001\u000e\u0003UAQ!\r\u0002A\u0002I\nqaY8oi\u0016DH/F\u0001@!\t\u0001e)D\u0001B\u0015\ti$I\u0003\u0002D\t\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001F\u0003\ry'oZ\u0005\u0003\u000f\u0006\u0013!#\u00119qY&\u001c\u0017\r^5p]\u000e{g\u000e^3yi\u0006Y1m\u001c8uKb$x\fJ3r)\tQU\n\u0005\u0002)\u0017&\u0011A*\u000b\u0002\u0005+:LG\u000fC\u0004O\t\u0005\u0005\t\u0019A \u0002\u0007a$\u0013'\u0001\u0005d_:$X\r\u001f;!Q\t)\u0011\u000b\u0005\u0002S36\t1K\u0003\u0002U+\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005Y;\u0016a\u00024bGR|'/\u001f\u0006\u00031\n\u000bQAY3b]NL!AW*\u0003\u0013\u0005+Ho\\<je\u0016$\u0017a\u0002:fC\u0012\fE\u000e\u001c\u000b\u0002;B\u0019aLZ5\u000f\u0005}#gB\u00011d\u001b\u0005\t'B\u00012&\u0003\u0019a$o\\8u}%\t!&\u0003\u0002fS\u00059\u0001/Y2lC\u001e,\u0017BA4i\u0005\u0011a\u0015n\u001d;\u000b\u0005\u0015L\u0003C\u00016n\u001b\u0005Y'B\u00017\u001a\u0003\r!Go\\\u0005\u0003].\u0014qAU8mK\u0012#x\u000e\u000b\u0003\u0007afT\bCA9x\u001b\u0005\u0011(B\u0001+t\u0015\t!X/\u0001\u0003cS:$'B\u0001<C\u0003\r9XMY\u0005\u0003qJ\u0014!bR3u\u001b\u0006\u0004\b/\u001b8h\u0003\u00151\u0018\r\\;fY\u0005Y\u0018%\u0001?\u0002\t=\nG\u000e\\\u0001\u0007GJ,\u0017\r^3\u0015\u0005%|\bbBA\u0001\u000f\u0001\u0007\u00111A\u0001\u0012GJ,\u0017\r^3S_2,'+Z9vKN$\bc\u00016\u0002\u0006%\u0019\u0011qA6\u0003#\r\u0013X-\u0019;f%>dWMU3rk\u0016\u001cH\u000fK\u0002\u0000\u0003\u0017\u00012!]A\u0007\u0013\r\tyA\u001d\u0002\f%\u0016\fX/Z:u\u0005>$\u0017\u0010K\u0002\u0000\u0003'\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0006wC2LG-\u0019;j_:T!!!\b\u0002\u000b)\fg/\u0019=\n\t\u0005\u0005\u0012q\u0003\u0002\u0006-\u0006d\u0017\u000e\u001a\u0015\u0004\u000f\u0005\u0015\u0002cA9\u0002(%\u0019\u0011\u0011\u0006:\u0003\u0017A{7\u000f^'baBLgnZ\u0001\u000fGJ,\u0017\r^3PeV\u0003H-\u0019;f)\rI\u0017q\u0006\u0005\b\u0003cA\u0001\u0019AA\u001a\u0003E)\b\u000fZ1uKJ{G.\u001a*fcV,7\u000f\u001e\t\u0004U\u0006U\u0012bAA\u001cW\n\tR\u000b\u001d3bi\u0016\u0014v\u000e\\3SKF,Xm\u001d;)\t\u0005=\u00121\u0002\u0015\u0005\u0003_\t\u0019\u0002\u000b\u0004\t\u0003KI\u0018q\b\u0017\u0003\u0003\u0003\n#!a\u0011\u0002\u000b=\u001a\u0018M^3\u0002\u0019\u0011,G.\u001a;f\u0005ft\u0015-\\3\u0015\u0007)\u000bI\u0005C\u0004\u0002L%\u0001\r!!\u0014\u0002\t9\fW.\u001a\t\u0005\u0003\u001f\n9F\u0004\u0003\u0002R\u0005M\u0003C\u00011*\u0013\r\t)&K\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00131\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005U\u0013\u0006\u000b\u0003\u0002J\u0005}\u0003cA9\u0002b%\u0019\u00111\r:\u0003\u0019A\u000bG\u000f\u001b,be&\f'\r\\3)\r%\t9'_A7!\r\t\u0018\u0011N\u0005\u0004\u0003W\u0012(!\u0004#fY\u0016$X-T1qa&tw\r\f\u0002\u0002p\u0005\u0012\u0011\u0011O\u0001\b_mt\u0017-\\3~\u0003)!W\r\\3uK\nK\u0018\n\u001a\u000b\u0004\u0015\u0006]\u0004bBA=\u0015\u0001\u0007\u00111P\u0001\u000ee>dW-\u00133SKF,Xm\u001d;\u0011\u0007)\fi(C\u0002\u0002\u0000-\u0014QBU8mK&#'+Z9vKN$\b\u0006BA<\u0003'AcACA4s\u0006\u0015EFAADC\t\tI)\u0001\b0S\u0012|3P]8mKV+\u0018\u000eZ?\u0002#\u0011,G.\u001a;f\u00032d'k\u001c7f%\u001647\u000fF\u0002K\u0003\u001fCq!a\u0013\f\u0001\u0004\ti\u0005\u000b\u0003\u0002\u0010\u0006}\u0003FB\u0006\u0002he\f)\n\f\u0002\u0002\u0018\u0006\u0012\u0011\u0011T\u0001\f_mt\u0017-\\3~_\u0005dG.A\u0005eK2,G/Z!mYR\t!\n\u000b\u0004\r\u0003OJ\u0018\u0011\u0015\u0017\u0002w\u00061Q\u000f\u001d3bi\u0016$2![AT\u0011\u001d\t\t$\u0004a\u0001\u0003gAC!a*\u0002\f!\"\u0011qUA\nQ\ri\u0011q\u0016\t\u0004c\u0006E\u0016bAAZe\nQ\u0001+\u001e;NCB\u0004\u0018N\\4\u0002\tI,\u0017\r\u001a\u000b\u0004S\u0006e\u0006bBA&\u001d\u0001\u0007\u0011Q\n\u0015\u0005\u0003s\u000by\u0006K\u0003\u000faf\fy\f\f\u0002\u0002pQ1\u00111YAj\u0003;\u0004R!!2\u0002P&l!!a2\u000b\t\u0005%\u00171Z\u0001\u0007I>l\u0017-\u001b8\u000b\u0007\u00055')\u0001\u0003eCR\f\u0017\u0002BAi\u0003\u000f\u0014A\u0001U1hK\"9\u0011Q[\bA\u0002\u0005]\u0017A\u00024jYR,'\u000fE\u0002k\u00033L1!a7l\u00055\u0011v\u000e\\3GS2$XM\u001d#u_\"9\u0011q\\\bA\u0002\u0005\u0005\u0018\u0001\u00039bO\u0016\f'\r\\3\u0011\t\u0005\u0015\u00171]\u0005\u0005\u0003K\f9M\u0001\u0005QC\u001e,\u0017M\u00197fQ\ty\u0001/\u0001\u0005sK\u0006$')_%e)\rI\u0017Q\u001e\u0005\b\u0003s\u0002\u0002\u0019AA>Q\u0011\ti/a\u0005)\u000bA\u0001\u00180a=-\u0005\u0005\u001d\u0015A\u0002:f]\u0006lW\rF\u0003j\u0003s\fi\u0010C\u0004\u0002LE\u0001\r!!\u0014)\t\u0005e\u0018q\f\u0005\b\u0003\u0003\t\u0002\u0019AA\u0002Q\u0011\ti0a\u0003)\t\u0005u\u00181\u0003\u0015\u0007#\u0005=\u0016P!\u0002-\u0005\t\u001d\u0011E\u0001B\u0005\u00039y3P\\1nKv|#/\u001a8b[\u0016\fQaY8v]R$BAa\u0004\u0003\u0016A\u0019\u0001F!\u0005\n\u0007\tM\u0011F\u0001\u0003M_:<\u0007b\u0002B\f%\u0001\u0007\u0011QJ\u0001\u0010e>dWMT1nKB\u000bG\u000f^3s]\"\"!QCA0Q\u0015\u0011\u0002/\u001fB\u000fY\t\u0011y\"\t\u0002\u0003\"\u0005ArfY8v]R|3P]8mK:\u000bW.\u001a)biR,'O\\?\u0002#I,\u0017\r\u001a\"z%>dW\rU1ui\u0016\u0014h\u000eF\u0002^\u0005OAq!!6\u0014\u0001\u0004\t9\u000eK\u0003\u0014af\u0014Y\u0003\f\u0002\u0003.\u0005\u0012!qF\u0001\b_\u0019LG\u000e^3sQ\u0019\u0001!1G=\u0003:A\u0019\u0011O!\u000e\n\u0007\t]\"O\u0001\bSKF,Xm\u001d;NCB\u0004\u0018N\\4-\u0005\tm\u0012E\u0001B\u001f\u0003%yc/M\u0018s_2,7\u000fK\u0002\u0001\u0005\u0003\u00022!\u001dB\"\u0013\r\u0011)E\u001d\u0002\u000f%\u0016\u001cHoQ8oiJ|G\u000e\\3s\u0001")
public class RolesController
implements RolesResource {
    private final RoleService roleService;
    @Autowired
    private ApplicationContext context;

    public ApplicationContext context() {
        return this.context;
    }

    public void context_$eq(ApplicationContext x$1) {
        this.context = x$1;
    }

    @Override
    @GetMapping(value={"/all"})
    public List<RoleDto> readAll() {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.readAll());
    }

    @Override
    @PostMapping
    public RoleDto create(@Valid @RequestBody CreateRoleRequest createRoleRequest) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.create(createRoleRequest.name()));
    }

    @Override
    @PostMapping(value={"/save"})
    public RoleDto createOrUpdate(@Valid @RequestBody UpdateRoleRequest updateRoleRequest) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.createOrUpdate(Role$.MODULE$.apply(UUID.fromString(updateRoleRequest.id()), updateRoleRequest.name())));
    }

    @Override
    @DeleteMapping(value={"/{name}"})
    public void deleteByName(@PathVariable String name) {
        this.roleService.delete(name);
    }

    @Override
    @DeleteMapping(value={"/id/{roleUuid}"})
    public void deleteById(@Valid RoleIdRequest roleIdRequest) {
        this.roleService.delete(UUID.fromString(roleIdRequest.roleUuid()));
    }

    @Override
    @DeleteMapping(value={"/{name}/all"})
    public void deleteAllRoleRefs(@PathVariable String name) {
        this.roleService.deleteAllRoleReferences(name);
    }

    @Override
    @DeleteMapping(value={"/all"})
    public void deleteAll() {
        this.roleService.removeAll();
    }

    @Override
    @PutMapping
    public RoleDto update(@Valid @RequestBody UpdateRoleRequest updateRoleRequest) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.update(Role$.MODULE$.apply(UUID.fromString(updateRoleRequest.id()), updateRoleRequest.name())));
    }

    @Override
    @GetMapping(value={"/{name}"})
    public RoleDto read(@PathVariable String name) {
        return RoleConverter$.MODULE$.roleToDto((Role)this.roleService.read(name).getOrElse((Function0 & Serializable)() -> {
            throw new RoleNameNotFoundException(name);
        }));
    }

    @Override
    @GetMapping
    public Page<RoleDto> read(RoleFilterDto filter, Pageable pageable) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.read(filter.namePattern(), pageable));
    }

    @Override
    @GetMapping(value={"/id/{roleUuid}"})
    public RoleDto readById(@Valid RoleIdRequest roleIdRequest) {
        return RoleConverter$.MODULE$.roleToDto((Role)this.roleService.read(UUID.fromString(roleIdRequest.roleUuid())).getOrElse((Function0 & Serializable)() -> {
            throw new RoleIdNotFoundException(roleIdRequest.roleUuid());
        }));
    }

    @Override
    @PutMapping(value={"/{name}/rename"})
    public RoleDto rename(@PathVariable String name, @Valid @RequestBody CreateRoleRequest createRoleRequest) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.rename(name, createRoleRequest.name()));
    }

    @Override
    @GetMapping(value={"/count/{roleNamePattern}"})
    public long count(@PathVariable String roleNamePattern) {
        return this.roleService.count(roleNamePattern);
    }

    @Override
    @GetMapping(value={"/filter"})
    public List<RoleDto> readByRolePattern(RoleFilterDto filter) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.readByRolePattern(filter.namePattern()));
    }

    public RolesController(RoleService roleService) {
        this.roleService = roleService;
    }
}

