package ai.digital.deploy.permissions.api.rest.v1.impl

import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter._
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithPrincipalsConverter.roleWithPrincipalsToDto
import ai.digital.deploy.permissions.api.rest.dto.{RoleFilterDto, RoleWithPrincipalsDto}
import ai.digital.deploy.permissions.api.rest.v1.RolePrincipalsPaths._
import ai.digital.deploy.permissions.api.rest.v1.RolePrincipalsResource
import ai.digital.deploy.permissions.service.RolePrincipalService
import org.springframework.data.domain.{Page, Pageable}
import org.springframework.validation.annotation.Validated
import org.springframework.web.bind.annotation._

@Validated
@RestController
@RequestMapping(Array(BASE_PATH))
class RolePrincipalsController(rolePrincipalService: RolePrincipalService) extends RolePrincipalsResource {
  @Deprecated
  @PostMapping(Array(ADD_PRINCIPALS_PATH))
  override def addPrincipals(@PathVariable roleName: String, @RequestBody principals: List[String]): RoleWithPrincipalsDto = {
    val (role, rolePrincipals) = rolePrincipalService.add(roleName, principals)
    RoleWithPrincipalsDto(role, rolePrincipals.map(_.principalName))
  }

  @Deprecated
  @DeleteMapping(Array(REMOVE_PRINCIPALS_PATH))
  override def removePrincipals(@PathVariable roleName: String, @RequestBody principals: List[String]): RoleWithPrincipalsDto = {
    val (role, rolePrincipals) = rolePrincipalService.remove(roleName, principals)
    RoleWithPrincipalsDto(role, rolePrincipals.map(_.principalName))
  }

  @GetMapping(Array(READ_PRINCIPALS_PATH))
  override def readPrincipals(@PathVariable roleName: String): List[String] =
    rolePrincipalService.read(roleName).map(_.principalName)

  @GetMapping(Array(READ_PRINCIPALS_PATH_ALL_ROLES))
  override def readPrincipalsForAllRoles(filter: RoleFilterDto, pageable: Pageable): Page[RoleWithPrincipalsDto] =
    roleWithPrincipalsToDto(pageable, rolePrincipalService.read(filter.namePattern, pageable))

  @GetMapping(Array(READ_PRINCIPALS_FOR_ROLE_PATTERN))
  override def readByRolePattern(filter: RoleFilterDto): List[RoleWithPrincipalsDto] =
    rolePrincipalService.readByRolePattern(filter.namePattern)

  @GetMapping(Array(READ_PRINCIPALS_FOR_PRINCIPAL_AND_ROLE_PATTERN))
  override def read(@PathVariable principal: String, filter: RoleFilterDto): List[RoleWithPrincipalsDto] =
    rolePrincipalService.read(principal, filter.namePattern)

  @GetMapping(Array(READ_PRINCIPALS_FOR_PRINCIPALS_AND_ROLE_PATTERN))
  override def read(@RequestBody principals: List[String], filter: RoleFilterDto): List[RoleWithPrincipalsDto] =
    rolePrincipalService.read(principals, filter.namePattern)

  @GetMapping(Array(READ_PRINCIPALS_FOR_PRINCIPALS_AND_ROLE_PATTERN_WITH_PAGING))
  override def read(@RequestBody principals: List[String],
                    filter: RoleFilterDto,
                    pageable: Pageable
  ): Page[RoleWithPrincipalsDto] =
    rolePrincipalService.read(principals, filter.namePattern, pageable)
}
