package ai.digital.deploy.permissions.api.rest.history

import ai.digital.deploy.permissions.api.rest.dto.{GetRolePrincipalHistoriesForPrincipalNameDto, GetRolePrincipalHistoriesForRoleIdDto, GetRolePrincipalHistoriesForRoleNameDto, GetRolePrincipalHistoriesForRolePrincipalIdDto}
import ai.digital.deploy.permissions.model.view.RolePrincipalHistory
import org.springframework.data.domain.{Page, Pageable}

trait HistoricalRolePrincipalResource {
  def getRolePrincipalHistoriesForPrincipalName(dto: GetRolePrincipalHistoriesForPrincipalNameDto,
                                                pageable: Pageable
  ): Page[RolePrincipalHistory]
  def getRolePrincipalHistoriesForRoleId(dto: GetRolePrincipalHistoriesForRoleIdDto,
                                         pageable: Pageable
  ): Page[RolePrincipalHistory]
  def getRolePrincipalHistoriesForRoleName(dto: GetRolePrincipalHistoriesForRoleNameDto,
                                           pageable: Pageable
  ): Page[RolePrincipalHistory]
  def getRolePrincipalHistoriesForRolePrincipalId(dto: GetRolePrincipalHistoriesForRolePrincipalIdDto,
                                                  pageable: Pageable
  ): Page[RolePrincipalHistory]
}
