package ai.digital.deploy.permissions.api.rest.v1

import ai.digital.deploy.permissions.api.rest.dto.{PermissionFilterDto, RoleWithGlobalPermissionsDto}
import ai.digital.deploy.permissions.rest.dto.validation.NonEmptyElements
import org.hibernate.validator.constraints.UniqueElements
import org.springframework.data.domain.{Page, Pageable}

import java.util.{List => JList}
import javax.validation.Valid
import javax.validation.constraints.NotNull

trait GlobalPermissionsResource {
  def addPermissions(roleName: String,
                     @UniqueElements(message = "{permission.added.list.duplicate}")
                     @NonEmptyElements(message = "{permission.listValues.not.empty}")
                     permissions: JList[String]
  ): RoleWithGlobalPermissionsDto

  def removePermissions(roleName: String,
                        @UniqueElements(message = "{permission.removed.list.duplicate}")
                        @NonEmptyElements(message = "{permission.listValues.not.empty}")
                        permissions: JList[String]
  ): RoleWithGlobalPermissionsDto

  def read(roleName: String): List[String]

  def read(permissionFilter: PermissionFilterDto, pageable: Pageable): Page[RoleWithGlobalPermissionsDto]

  def readByRolePattern(permissionFilter: PermissionFilterDto): List[RoleWithGlobalPermissionsDto]

  def readForRoles(@Valid @NotNull roleIds: List[String]): List[RoleWithGlobalPermissionsDto]
}
