package ai.digital.deploy.permissions.api.rest.v1

import ai.digital.deploy.permissions.api.rest.dto._
import org.springframework.data.domain.{Page, Pageable}

trait RolesResource {
  def create(createRoleRequest: CreateRoleRequest): RoleDto

  def createOrUpdate(updateRoleRequest: UpdateRoleRequest): RoleDto

  def deleteByName(name: String): Unit

  def deleteById(roleIdRequest: RoleIdRequest): Unit

  def deleteAllRoleRefs(name: String): Unit

  def deleteAll(): Unit

  def update(updateRoleRequest: UpdateRoleRequest): RoleDto

  def readAll(): List[RoleDto]

  def read(name: String): RoleDto

  def read(filter: RoleFilterDto, pageable: Pageable): Page[RoleDto]

  def readById(roleIdRequest: RoleIdRequest): RoleDto

  def rename(name: String, createRoleRequest: CreateRoleRequest): RoleDto

  def count(roleNamePattern: String): Long

  def readByRolePattern(filter: RoleFilterDto): List[RoleDto]
}
