package ai.digital.deploy.permissions.api.rest.v1.impl

import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter._
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithReferencedPermissionsConverter._
import ai.digital.deploy.permissions.api.rest.dto.{PermissionFilterDto, RoleWithReferencedPermissionsDto}
import ai.digital.deploy.permissions.api.rest.v1.ReferencedPermissionsPaths._
import ai.digital.deploy.permissions.api.rest.v1.ReferencedPermissionsResource
import ai.digital.deploy.permissions.service.ReferencedPermissionService
import org.springframework.data.domain.{Page, Pageable}
import org.springframework.validation.annotation.Validated
import org.springframework.web.bind.annotation._

import java.util.{UUID, List => JList}
import scala.jdk.CollectionConverters._

@Validated
@RestController
@RequestMapping(Array(BASE_PATH))
class ReferencedPermissionsController(referencedPermissionService: ReferencedPermissionService)
    extends ReferencedPermissionsResource {
  @Deprecated
  @PostMapping(Array(ADD_PERMISSIONS_PATH))
  override def addPermissions(@PathVariable referenceId: String,
                              @PathVariable roleName: String,
                              @RequestBody permissions: JList[String]
  ): RoleWithReferencedPermissionsDto = {
    val uuid = UUID.fromString(referenceId)
    val (role, rp) = referencedPermissionService.add(uuid, roleName, permissions.asScala.toList)
    RoleWithReferencedPermissionsDto(role, uuid, rp)
  }

  @Deprecated
  @DeleteMapping(Array(REMOVE_PERMISSIONS_PATH))
  override def removePermissions(@PathVariable referenceId: String,
                                 @PathVariable roleName: String,
                                 @RequestBody permissions: JList[String]
  ): RoleWithReferencedPermissionsDto = {
    val uuid = UUID.fromString(referenceId)
    val (role, rp) = referencedPermissionService.remove(uuid, roleName, permissions.asScala.toList)
    RoleWithReferencedPermissionsDto(role, uuid, rp)
  }

  @GetMapping(Array(READ_REFERENCED_ROLE_PERMISSIONS_PATH))
  override def read(@PathVariable referenceId: String, @PathVariable roleName: String): List[String] =
    referencedPermissionService.read(UUID.fromString(referenceId), roleName).map(_.permissionName)

  @GetMapping(Array(READ_REFERENCED_PERMISSIONS))
  override def read(@PathVariable referenceId: String,
                    permissionFilter: PermissionFilterDto,
                    pageable: Pageable
  ): Page[RoleWithReferencedPermissionsDto] = {
    val uuid = UUID.fromString(referenceId)
    roleReferencedPermissionViewToDto(
      uuid,
      pageable,
      referencedPermissionService.read(uuid, permissionFilter.rolePattern, pageable)
    )
  }

  @GetMapping(Array(READ_REFERENCED_PERMISSIONS_BY_ROLE_PATTERN))
  override def readByRolePattern(@PathVariable referenceId: String,
                                 permissionFilter: PermissionFilterDto
  ): List[RoleWithReferencedPermissionsDto] =
    referencedPermissionService
      .readForRolePattern(UUID.fromString(referenceId), permissionFilter.rolePattern).groupBy(_.role).flatMap {
        case (role, permissions) =>
          val groupByReference = permissions.groupBy(_.reference)
          groupByReference.map {
            case (reference, referencePermissions) =>
              RoleWithReferencedPermissionsDto(role, reference, referencePermissions.map(_.permissionName))
          }
      }.toList
}
